/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.providers.tasks;

import com.meniga.sdk.providers.tasks.AndroidExecutors;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

final class MenigaExecutors {
    private static final MenigaExecutors INSTANCE = new MenigaExecutors();
    private final ExecutorService background = !MenigaExecutors.isAndroidRuntime() ? Executors.newCachedThreadPool() : AndroidExecutors.newCachedThreadPool();
    private final ScheduledExecutorService scheduled = Executors.newSingleThreadScheduledExecutor();
    private final Executor immediate = new ImmediateExecutor();

    private static boolean isAndroidRuntime() {
        String javaRuntimeName = System.getProperty("java.runtime.name");
        return javaRuntimeName != null && javaRuntimeName.toLowerCase(Locale.US).contains("android");
    }

    private MenigaExecutors() {
    }

    static ExecutorService background() {
        return MenigaExecutors.INSTANCE.background;
    }

    static ScheduledExecutorService scheduled() {
        return MenigaExecutors.INSTANCE.scheduled;
    }

    static Executor immediate() {
        return MenigaExecutors.INSTANCE.immediate;
    }

    private static class ImmediateExecutor
    implements Executor {
        private static final int MAX_DEPTH = 15;
        private ThreadLocal<Integer> executionDepth = new ThreadLocal();

        private ImmediateExecutor() {
        }

        private int incrementDepth() {
            Integer oldDepth = this.executionDepth.get();
            if (oldDepth == null) {
                oldDepth = 0;
            }
            int newDepth = oldDepth + 1;
            this.executionDepth.set(newDepth);
            return newDepth;
        }

        private int decrementDepth() {
            int newDepth;
            Integer oldDepth = this.executionDepth.get();
            if (oldDepth == null) {
                oldDepth = 0;
            }
            if ((newDepth = oldDepth - 1) == 0) {
                this.executionDepth.remove();
            } else {
                this.executionDepth.set(newDepth);
            }
            return newDepth;
        }

        @Override
        public void execute(Runnable command) {
            int depth = this.incrementDepth();
            try {
                if (depth <= 15) {
                    command.run();
                } else {
                    MenigaExecutors.background().execute(command);
                }
            }
            finally {
                this.decrementDepth();
            }
        }
    }
}

