/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.providers;

import com.meniga.sdk.ErrorHandler;
import com.meniga.sdk.adapters.TaskAdapter;
import com.meniga.sdk.helpers.Interceptor;
import com.meniga.sdk.helpers.MTask;
import com.meniga.sdk.helpers.Result;
import com.meniga.sdk.helpers.ResultMapper;
import com.meniga.sdk.providers.tasks.Continuation;
import com.meniga.sdk.providers.tasks.Task;
import com.meniga.sdk.providers.tasks.TaskCompletionSource;
import com.meniga.sdk.webservices.MenigaWebException;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class BasicTaskAdapter
implements TaskAdapter {
    @Override
    public <T> Result<T> adapt(Call<T> call, Callback<T> callBack) {
        if (callBack == null) {
            callBack = new Callback<T>(){

                public void onResponse(Call<T> call, Response<T> response) {
                }

                public void onFailure(Call<T> call, Throwable t) {
                }
            };
        }
        final Callback finalCall = callBack;
        final TaskCompletionSource<T> tcs = new TaskCompletionSource<T>(call);
        call.enqueue(new Callback<T>(){

            public void onResponse(Call<T> call, Response<T> response) {
                if (call.isCanceled()) {
                    tcs.setCancelled();
                } else if (response.isSuccessful()) {
                    tcs.setResult(response.body());
                    finalCall.onResponse(call, response);
                } else {
                    ErrorHandler.reportAndHandle(new Exception(response.message()));
                    String msg = response.message();
                    try {
                        msg = response.errorBody().string();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    tcs.setError(new MenigaWebException(msg, response.code()));
                }
            }

            public void onFailure(Call<T> call, Throwable error) {
                ErrorHandler.reportAndHandle(error);
                if (error == null && !tcs.getTask().isCancelled()) {
                    tcs.setError(new Exception("[No error message provided]"));
                } else if (call.isCanceled() && !tcs.getTask().isCompleted()) {
                    tcs.setCancelled();
                } else if (!tcs.getTask().isCompleted()) {
                    if (error != null) {
                        tcs.setError(new MenigaWebException(error.getMessage(), -1));
                    } else {
                        tcs.setError(new MenigaWebException("[No error message provided]", -1));
                    }
                }
            }
        });
        return new MTask<T>(tcs.getTask(), tcs);
    }

    public <T> MTask<T> adapt(T value) {
        TaskCompletionSource<T> tcs = new TaskCompletionSource<T>(null);
        tcs.trySetResult(value);
        return new MTask(tcs.getTask(), tcs);
    }

    @Override
    public <T> Result<T> intercept(Result<T> request, final Interceptor<T> intercept) {
        final TaskCompletionSource tcs = new TaskCompletionSource();
        final Task<T> res = request.getTask();
        final Result<T> finalRequest = request;
        res.continueWithTask(new Continuation<T, Task<T>>(){

            @Override
            public Task<T> then(Task<T> task2) throws Exception {
                if (!task2.isCancelled()) {
                    if (task2.isFaulted()) {
                        tcs.setError(task2.getError());
                    } else {
                        tcs.setResult(task2.getResult());
                    }
                    intercept.onFinished(task2.getResult(), task2.isFaulted());
                }
                return tcs.getTask();
            }
        });
        return new Result<T>(){

            @Override
            public Task<T> getTask() {
                return res;
            }

            @Override
            public void cancel() {
                finalRequest.cancel();
            }

            @Override
            @NotNull
            public <R> Result<R> map(@NotNull Function1<? super T, ? extends R> mapper) {
                return finalRequest.map(mapper);
            }
        };
    }

    @Override
    public <T> Result<T> intercept(final Task<T> task2, Interceptor<T> intercept) {
        Result result = new Result<T>(){

            @Override
            public Task<T> getTask() {
                return task2;
            }

            @Override
            public void cancel() {
            }

            @Override
            @NotNull
            public <R> Result<R> map(@NotNull Function1<? super T, ? extends R> mapper) {
                return new ResultMapper(this, mapper);
            }
        };
        return this.intercept(result, intercept);
    }
}

