/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.userevents;

import android.os.Parcel;
import android.os.Parcelable;
import com.meniga.sdk.helpers.Result;
import com.meniga.sdk.models.userevents.UserEventSetting;
import com.meniga.sdk.models.userevents.UserEventSubscription;
import com.meniga.sdk.models.userevents.enums.UserEventType;
import com.meniga.sdk.models.userevents.operators.MenigaUserEventsOperations;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MenigaUserEvent
implements Serializable,
Parcelable,
Cloneable {
    protected static MenigaUserEventsOperations apiOperations;
    protected String userEventTypeIdentifier;
    protected List<UserEventSubscription> subscriptions;
    protected List<UserEventSetting> settings;
    protected List<MenigaUserEvent> children;
    public static final Parcelable.Creator<MenigaUserEvent> CREATOR;

    public static void setOperator(MenigaUserEventsOperations operator) {
        apiOperations = operator;
    }

    protected MenigaUserEvent() {
    }

    public UserEventType getUserEventTypeIdentifier() {
        return this.userEventTypeIdentifier == null ? UserEventType.UNKNOWN : UserEventType.parse(this.userEventTypeIdentifier);
    }

    public List<UserEventSubscription> getSubscriptions() {
        return this.subscriptions;
    }

    public List<UserEventSetting> getSettings() {
        return this.settings;
    }

    public List<MenigaUserEvent> getChildren() {
        return this.children;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MenigaUserEvent that = (MenigaUserEvent)o;
        if (this.userEventTypeIdentifier != null ? !this.userEventTypeIdentifier.equals(that.userEventTypeIdentifier) : that.userEventTypeIdentifier != null) {
            return false;
        }
        if (this.subscriptions != null ? !this.subscriptions.equals(that.subscriptions) : that.subscriptions != null) {
            return false;
        }
        if (this.settings != null ? !this.settings.equals(that.settings) : that.settings != null) {
            return false;
        }
        return this.children != null ? this.children.equals(that.children) : that.children == null;
    }

    public int hashCode() {
        int result = this.userEventTypeIdentifier != null ? this.userEventTypeIdentifier.hashCode() : 0;
        result = 31 * result + (this.subscriptions != null ? this.subscriptions.hashCode() : 0);
        result = 31 * result + (this.settings != null ? this.settings.hashCode() : 0);
        result = 31 * result + (this.children != null ? this.children.hashCode() : 0);
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.userEventTypeIdentifier);
        dest.writeTypedList(this.subscriptions);
        dest.writeTypedList(this.settings);
        dest.writeTypedList(this.children);
    }

    protected MenigaUserEvent(Parcel in) {
        this.userEventTypeIdentifier = in.readString();
        this.subscriptions = in.createTypedArrayList(UserEventSubscription.CREATOR);
        this.settings = in.createTypedArrayList(UserEventSetting.CREATOR);
        this.children = in.createTypedArrayList(CREATOR);
    }

    public static Result<List<MenigaUserEvent>> fetch() {
        return apiOperations.getUserEvents();
    }

    public static Result<Void> subscribe(List<MenigaUserEvent> userEvents, boolean subscribed, String channel, String reason) {
        ArrayList<UserEventType> userEventTypeIdentifier = new ArrayList<UserEventType>();
        for (int i = 0; i < userEvents.size(); ++i) {
            for (int j = 0; j < userEvents.get(i).getSubscriptions().size(); ++j) {
                UserEventSubscription sub = userEvents.get(i).getSubscriptions().get(j);
                if (!sub.getChannelName().equals(channel)) continue;
                userEventTypeIdentifier.add(userEvents.get(i).getUserEventTypeIdentifier());
            }
        }
        return apiOperations.setSubscription(userEventTypeIdentifier, subscribed, channel, reason);
    }

    public static Result<Void> updateSettings(Map<String, String> subscriptionSettings) {
        return apiOperations.updateSettings(subscriptionSettings);
    }

    static {
        CREATOR = new Parcelable.Creator<MenigaUserEvent>(){

            public MenigaUserEvent createFromParcel(Parcel source) {
                return new MenigaUserEvent(source);
            }

            public MenigaUserEvent[] newArray(int size) {
                return new MenigaUserEvent[size];
            }
        };
    }
}

