/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.user;

import android.os.Parcel;
import android.os.Parcelable;
import com.meniga.sdk.helpers.Result;
import com.meniga.sdk.models.user.MenigaUserMetaData;
import com.meniga.sdk.models.user.MenigaUserProfile;
import com.meniga.sdk.models.user.operators.MenigaUserOperations;
import com.meniga.sdk.webservices.MenigaWebException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;

public class MenigaUser
implements Serializable,
Parcelable,
Cloneable {
    public static final Parcelable.Creator<MenigaUser> CREATOR = new Parcelable.Creator<MenigaUser>(){

        public MenigaUser createFromParcel(Parcel source) {
            return new MenigaUser(source);
        }

        public MenigaUser[] newArray(int size) {
            return new MenigaUser[size];
        }
    };
    protected static MenigaUserOperations apiOperator;
    public MenigaWebException ex;
    protected DateTime created;
    protected String culture;
    protected String email;
    protected DateTime lastLoginDate;
    protected String firstName;
    protected String lastName;
    protected long personId;
    protected String realmUserIdentity;
    protected DateTime termsAndConditionsAcceptDate;
    protected Integer termsAndConditionsId;
    protected long userId;
    protected MenigaUserProfile profile;

    protected MenigaUser() {
    }

    protected MenigaUser(Parcel in) {
        this.created = (DateTime)in.readSerializable();
        this.culture = in.readString();
        this.email = in.readString();
        this.lastLoginDate = (DateTime)in.readSerializable();
        this.firstName = in.readString();
        this.lastName = in.readString();
        this.personId = in.readLong();
        this.realmUserIdentity = in.readString();
        this.termsAndConditionsAcceptDate = (DateTime)in.readSerializable();
        this.termsAndConditionsId = (Integer)in.readValue(Integer.class.getClassLoader());
        this.userId = in.readLong();
        this.profile = (MenigaUserProfile)in.readParcelable(MenigaUserProfile.class.getClassLoader());
    }

    public static void setOperator(MenigaUserOperations operator) {
        apiOperator = operator;
    }

    protected MenigaUser clone() throws CloneNotSupportedException {
        return (MenigaUser)super.clone();
    }

    public long getPersonId() {
        return this.personId;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public MenigaUserProfile getProfile() {
        return this.profile;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public String getCulture() {
        return this.culture;
    }

    public String getEmail() {
        return this.email;
    }

    public DateTime getLastLoginDate() {
        return this.lastLoginDate;
    }

    public String getRealmUserIdentity() {
        return this.realmUserIdentity;
    }

    public DateTime getTermsAndConditionsAcceptDate() {
        return this.termsAndConditionsAcceptDate;
    }

    public Integer getTermsAndConditionsId() {
        return this.termsAndConditionsId;
    }

    public long getUserId() {
        return this.userId;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeSerializable((Serializable)this.created);
        dest.writeString(this.culture);
        dest.writeString(this.email);
        dest.writeSerializable((Serializable)this.lastLoginDate);
        dest.writeString(this.firstName);
        dest.writeString(this.lastName);
        dest.writeLong(this.personId);
        dest.writeString(this.realmUserIdentity);
        dest.writeSerializable((Serializable)this.termsAndConditionsAcceptDate);
        dest.writeValue((Object)this.termsAndConditionsId);
        dest.writeLong(this.userId);
        dest.writeParcelable((Parcelable)this.profile, flags);
    }

    public static Result<List<MenigaUser>> fetch() {
        return apiOperator.getUsers();
    }

    public static Result<Void> setCulture(String culture) {
        return apiOperator.setCulture(culture);
    }

    public static Result<MenigaUser> create(String email, String password, String culture) {
        return apiOperator.registerUser(email, password, culture);
    }

    public static Result<Void> forgotPassword(String email) {
        return apiOperator.forgotPassword(email);
    }

    public static Result<List<MenigaUserMetaData>> fetchMetaData() {
        return apiOperator.getUserMetaData(new ArrayList<String>());
    }

    public static Result<List<MenigaUserMetaData>> fetchMetaData(List<String> filter) {
        return apiOperator.getUserMetaData(filter);
    }

    public static Result<MenigaUserMetaData> saveMetaData(String key, String value) {
        return apiOperator.saveMetaData(key, value);
    }

    public static Result<Void> resetPassword(String resetPasswordToken, String email, String newPassword) {
        return apiOperator.resetPassword(resetPasswordToken, email, newPassword);
    }

    @NotNull
    public static Result<Void> updateEmail(@NotNull String newEmail, @NotNull String password) {
        return apiOperator.updateEmail(newEmail, password);
    }

    @NotNull
    public static Result<Void> changePassword(@NotNull String currentPassword, @NotNull String newPassword) {
        return apiOperator.changePassword(currentPassword, newPassword);
    }

    @NotNull
    public static Result<Void> delete() {
        return apiOperator.delete();
    }
}

