/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.upcoming;

import android.os.Parcel;
import android.os.Parcelable;
import com.meniga.sdk.helpers.MenigaDecimal;
import com.meniga.sdk.models.upcoming.enums.PaymentStatus;
import java.io.Serializable;
import org.joda.time.DateTime;

public class MenigaUpcomingScheduledPayment
implements Serializable,
Parcelable,
Cloneable {
    protected long id;
    protected String identifier;
    protected String bankReference;
    protected String paymentText;
    protected String referenceText;
    protected MenigaDecimal amountInCurrency;
    protected String currencyCode;
    protected DateTime issuedDate;
    protected DateTime dueDate;
    protected DateTime bookingDate;
    protected PaymentStatus paymentStatus;
    protected String parsedData;
    protected Boolean isReceivable;
    protected String sourceAccIdentifier;
    protected String destinationAccIdentifier;
    public static final Parcelable.Creator<MenigaUpcomingScheduledPayment> CREATOR = new Parcelable.Creator<MenigaUpcomingScheduledPayment>(){

        public MenigaUpcomingScheduledPayment createFromParcel(Parcel source) {
            return new MenigaUpcomingScheduledPayment(source);
        }

        public MenigaUpcomingScheduledPayment[] newArray(int size) {
            return new MenigaUpcomingScheduledPayment[size];
        }
    };

    protected MenigaUpcomingScheduledPayment() {
    }

    public MenigaUpcomingScheduledPayment clone() throws CloneNotSupportedException {
        return (MenigaUpcomingScheduledPayment)super.clone();
    }

    public long getId() {
        return this.id;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getBankReference() {
        return this.bankReference;
    }

    public String getPaymentText() {
        return this.paymentText;
    }

    public String getReferenceText() {
        return this.referenceText;
    }

    public MenigaDecimal getAmountInCurrency() {
        return this.amountInCurrency;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public DateTime getIssuedDate() {
        return this.issuedDate;
    }

    public DateTime getDueDate() {
        return this.dueDate;
    }

    public DateTime getBookingDate() {
        return this.bookingDate;
    }

    public PaymentStatus getPaymentStatus() {
        return this.paymentStatus;
    }

    public String getParsedData() {
        return this.parsedData;
    }

    public Boolean getReceivable() {
        return this.isReceivable;
    }

    public String getSourceAccIdentifier() {
        return this.sourceAccIdentifier;
    }

    public String getDestinationAccIdentifier() {
        return this.destinationAccIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MenigaUpcomingScheduledPayment that = (MenigaUpcomingScheduledPayment)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.identifier != null ? !this.identifier.equals(that.identifier) : that.identifier != null) {
            return false;
        }
        if (this.bankReference != null ? !this.bankReference.equals(that.bankReference) : that.bankReference != null) {
            return false;
        }
        if (this.paymentText != null ? !this.paymentText.equals(that.paymentText) : that.paymentText != null) {
            return false;
        }
        if (this.referenceText != null ? !this.referenceText.equals(that.referenceText) : that.referenceText != null) {
            return false;
        }
        if (this.amountInCurrency != null ? !this.amountInCurrency.equals(that.amountInCurrency) : that.amountInCurrency != null) {
            return false;
        }
        if (this.currencyCode != null ? !this.currencyCode.equals(that.currencyCode) : that.currencyCode != null) {
            return false;
        }
        if (this.issuedDate != null ? !this.issuedDate.equals((Object)that.issuedDate) : that.issuedDate != null) {
            return false;
        }
        if (this.dueDate != null ? !this.dueDate.equals((Object)that.dueDate) : that.dueDate != null) {
            return false;
        }
        if (this.bookingDate != null ? !this.bookingDate.equals((Object)that.bookingDate) : that.bookingDate != null) {
            return false;
        }
        if (this.paymentStatus != that.paymentStatus) {
            return false;
        }
        if (this.parsedData != null ? !this.parsedData.equals(that.parsedData) : that.parsedData != null) {
            return false;
        }
        if (this.isReceivable != null ? !this.isReceivable.equals(that.isReceivable) : that.isReceivable != null) {
            return false;
        }
        if (this.sourceAccIdentifier != null ? !this.sourceAccIdentifier.equals(that.sourceAccIdentifier) : that.sourceAccIdentifier != null) {
            return false;
        }
        return this.destinationAccIdentifier != null ? this.destinationAccIdentifier.equals(that.destinationAccIdentifier) : that.destinationAccIdentifier == null;
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.identifier != null ? this.identifier.hashCode() : 0);
        result = 31 * result + (this.bankReference != null ? this.bankReference.hashCode() : 0);
        result = 31 * result + (this.paymentText != null ? this.paymentText.hashCode() : 0);
        result = 31 * result + (this.referenceText != null ? this.referenceText.hashCode() : 0);
        result = 31 * result + (this.amountInCurrency != null ? this.amountInCurrency.hashCode() : 0);
        result = 31 * result + (this.currencyCode != null ? this.currencyCode.hashCode() : 0);
        result = 31 * result + (this.issuedDate != null ? this.issuedDate.hashCode() : 0);
        result = 31 * result + (this.dueDate != null ? this.dueDate.hashCode() : 0);
        result = 31 * result + (this.bookingDate != null ? this.bookingDate.hashCode() : 0);
        result = 31 * result + (this.paymentStatus != null ? this.paymentStatus.hashCode() : 0);
        result = 31 * result + (this.parsedData != null ? this.parsedData.hashCode() : 0);
        result = 31 * result + (this.isReceivable != null ? this.isReceivable.hashCode() : 0);
        result = 31 * result + (this.sourceAccIdentifier != null ? this.sourceAccIdentifier.hashCode() : 0);
        result = 31 * result + (this.destinationAccIdentifier != null ? this.destinationAccIdentifier.hashCode() : 0);
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.id);
        dest.writeString(this.identifier);
        dest.writeString(this.bankReference);
        dest.writeString(this.paymentText);
        dest.writeString(this.referenceText);
        dest.writeSerializable((Serializable)this.amountInCurrency);
        dest.writeString(this.currencyCode);
        dest.writeSerializable((Serializable)this.issuedDate);
        dest.writeSerializable((Serializable)this.dueDate);
        dest.writeSerializable((Serializable)this.bookingDate);
        dest.writeInt(this.paymentStatus == null ? -1 : this.paymentStatus.ordinal());
        dest.writeString(this.parsedData);
        dest.writeValue((Object)this.isReceivable);
        dest.writeString(this.sourceAccIdentifier);
        dest.writeString(this.destinationAccIdentifier);
    }

    protected MenigaUpcomingScheduledPayment(Parcel in) {
        this.id = in.readLong();
        this.identifier = in.readString();
        this.bankReference = in.readString();
        this.paymentText = in.readString();
        this.referenceText = in.readString();
        this.amountInCurrency = (MenigaDecimal)in.readSerializable();
        this.currencyCode = in.readString();
        this.issuedDate = (DateTime)in.readSerializable();
        this.dueDate = (DateTime)in.readSerializable();
        this.bookingDate = (DateTime)in.readSerializable();
        int tmpPaymentStatus = in.readInt();
        this.paymentStatus = tmpPaymentStatus == -1 ? null : PaymentStatus.values()[tmpPaymentStatus];
        this.parsedData = in.readString();
        this.isReceivable = (Boolean)in.readValue(Boolean.class.getClassLoader());
        this.sourceAccIdentifier = in.readString();
        this.destinationAccIdentifier = in.readString();
    }
}

