/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.transactions;

import android.os.Parcel;
import android.os.Parcelable;
import com.meniga.sdk.MenigaSDK;
import com.meniga.sdk.helpers.Interceptor;
import com.meniga.sdk.helpers.MenigaDecimal;
import com.meniga.sdk.helpers.Result;
import com.meniga.sdk.models.Merge;
import com.meniga.sdk.models.transactions.enums.AmountLimitSignCriteria;
import com.meniga.sdk.models.transactions.enums.AmountLimitTypeCriteria;
import com.meniga.sdk.models.transactions.enums.DateMatchTypeCriteria;
import com.meniga.sdk.models.transactions.enums.TransactionRuleTextCriteriaOperatorType;
import com.meniga.sdk.models.transactions.operators.MenigaTransactionRuleOperations;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;

public class MenigaTransactionRule
implements Parcelable,
Serializable,
Cloneable {
    public static final Parcelable.Creator<MenigaTransactionRule> CREATOR = new Parcelable.Creator<MenigaTransactionRule>(){

        public MenigaTransactionRule createFromParcel(Parcel source) {
            return new MenigaTransactionRule(source);
        }

        public MenigaTransactionRule[] newArray(int size) {
            return new MenigaTransactionRule[size];
        }
    };
    protected static MenigaTransactionRuleOperations apiOperator;
    protected long id;
    protected long userId;
    protected DateTime createdDate;
    protected DateTime modifiedDate;
    protected String name;
    protected String textCriteria;
    protected TransactionRuleTextCriteriaOperatorType textCriteriaOperatorType;
    protected DateMatchTypeCriteria dateMatchTypeCriteria;
    protected Integer daysLimitCriteria;
    protected AmountLimitTypeCriteria amountLimitTypeCriteria;
    protected AmountLimitSignCriteria amountLimitSignCriteria;
    protected MenigaDecimal amountCriteria;
    protected String accountCategoryCriteria;
    protected Boolean acceptAction;
    protected Integer monthShiftAction;
    protected Boolean removeAction;
    protected String textAction;
    protected String commentAction;
    protected Long categoryIdAction;
    protected List<SplitAction> splitActions;
    protected Boolean flagAction;
    protected String tagAction;

    protected MenigaTransactionRule() {
    }

    protected MenigaTransactionRule(Parcel in) {
        this.id = in.readLong();
        this.userId = in.readLong();
        this.createdDate = (DateTime)in.readSerializable();
        this.modifiedDate = (DateTime)in.readSerializable();
        this.name = in.readString();
        this.textCriteria = in.readString();
        int tmpTextCriteriaOperatorType = in.readInt();
        this.textCriteriaOperatorType = tmpTextCriteriaOperatorType == -1 ? null : TransactionRuleTextCriteriaOperatorType.values()[tmpTextCriteriaOperatorType];
        int tmpDateMatchTypeCriteria = in.readInt();
        this.dateMatchTypeCriteria = tmpDateMatchTypeCriteria == -1 ? null : DateMatchTypeCriteria.values()[tmpDateMatchTypeCriteria];
        this.daysLimitCriteria = (Integer)in.readValue(Integer.class.getClassLoader());
        int tmpAmountLimitTypeCriteria = in.readInt();
        this.amountLimitTypeCriteria = tmpAmountLimitTypeCriteria == -1 ? null : AmountLimitTypeCriteria.values()[tmpAmountLimitTypeCriteria];
        int tmpAmountLimitSignCriteria = in.readInt();
        this.amountLimitSignCriteria = tmpAmountLimitSignCriteria == -1 ? null : AmountLimitSignCriteria.values()[tmpAmountLimitSignCriteria];
        this.amountCriteria = (MenigaDecimal)in.readSerializable();
        this.accountCategoryCriteria = in.readString();
        this.acceptAction = (Boolean)in.readValue(Boolean.class.getClassLoader());
        this.monthShiftAction = (Integer)in.readValue(Integer.class.getClassLoader());
        this.removeAction = (Boolean)in.readValue(Boolean.class.getClassLoader());
        this.textAction = in.readString();
        this.commentAction = in.readString();
        this.categoryIdAction = (Long)in.readValue(Long.class.getClassLoader());
        this.splitActions = new ArrayList<SplitAction>();
        in.readList(this.splitActions, SplitAction.class.getClassLoader());
        this.flagAction = (Boolean)in.readValue(Boolean.class.getClassLoader());
        this.tagAction = in.readString();
    }

    public static void setOperator(MenigaTransactionRuleOperations operator) {
        apiOperator = operator;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.id);
        dest.writeLong(this.userId);
        dest.writeSerializable((Serializable)this.createdDate);
        dest.writeSerializable((Serializable)this.modifiedDate);
        dest.writeString(this.name);
        dest.writeString(this.textCriteria);
        dest.writeInt(this.textCriteriaOperatorType == null ? -1 : this.textCriteriaOperatorType.ordinal());
        dest.writeInt(this.dateMatchTypeCriteria == null ? -1 : this.dateMatchTypeCriteria.ordinal());
        dest.writeValue((Object)this.daysLimitCriteria);
        dest.writeInt(this.amountLimitTypeCriteria == null ? -1 : this.amountLimitTypeCriteria.ordinal());
        dest.writeInt(this.amountLimitSignCriteria == null ? -1 : this.amountLimitSignCriteria.ordinal());
        dest.writeSerializable((Serializable)this.amountCriteria);
        dest.writeString(this.accountCategoryCriteria);
        dest.writeValue((Object)this.acceptAction);
        dest.writeValue((Object)this.monthShiftAction);
        dest.writeValue((Object)this.removeAction);
        dest.writeString(this.textAction);
        dest.writeString(this.commentAction);
        dest.writeValue((Object)this.categoryIdAction);
        dest.writeList(this.splitActions);
        dest.writeValue((Object)this.flagAction);
        dest.writeString(this.tagAction);
    }

    public int describeContents() {
        return 0;
    }

    public MenigaTransactionRule clone() throws CloneNotSupportedException {
        return (MenigaTransactionRule)super.clone();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MenigaTransactionRule that = (MenigaTransactionRule)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.userId != that.userId) {
            return false;
        }
        if (this.createdDate != null ? !this.createdDate.equals((Object)that.createdDate) : that.createdDate != null) {
            return false;
        }
        if (this.modifiedDate != null ? !this.modifiedDate.equals((Object)that.modifiedDate) : that.modifiedDate != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.textCriteria != null ? !this.textCriteria.equals(that.textCriteria) : that.textCriteria != null) {
            return false;
        }
        if (this.textCriteriaOperatorType != that.textCriteriaOperatorType) {
            return false;
        }
        if (this.dateMatchTypeCriteria != that.dateMatchTypeCriteria) {
            return false;
        }
        if (this.daysLimitCriteria != null ? !this.daysLimitCriteria.equals(that.daysLimitCriteria) : that.daysLimitCriteria != null) {
            return false;
        }
        if (this.amountLimitTypeCriteria != that.amountLimitTypeCriteria) {
            return false;
        }
        if (this.amountLimitSignCriteria != that.amountLimitSignCriteria) {
            return false;
        }
        if (this.amountCriteria != null ? !this.amountCriteria.equals(that.amountCriteria) : that.amountCriteria != null) {
            return false;
        }
        if (this.accountCategoryCriteria != null ? !this.accountCategoryCriteria.equals(that.accountCategoryCriteria) : that.accountCategoryCriteria != null) {
            return false;
        }
        if (this.acceptAction != null ? !this.acceptAction.equals(that.acceptAction) : that.acceptAction != null) {
            return false;
        }
        if (this.monthShiftAction != null ? !this.monthShiftAction.equals(that.monthShiftAction) : that.monthShiftAction != null) {
            return false;
        }
        if (this.removeAction != null ? !this.removeAction.equals(that.removeAction) : that.removeAction != null) {
            return false;
        }
        if (this.textAction != null ? !this.textAction.equals(that.textAction) : that.textAction != null) {
            return false;
        }
        if (this.commentAction != null ? !this.commentAction.equals(that.commentAction) : that.commentAction != null) {
            return false;
        }
        if (this.categoryIdAction != null ? !this.categoryIdAction.equals(that.categoryIdAction) : that.categoryIdAction != null) {
            return false;
        }
        if (this.splitActions != null ? !this.splitActions.equals(that.splitActions) : that.splitActions != null) {
            return false;
        }
        if (this.flagAction != null ? !this.flagAction.equals(that.flagAction) : that.flagAction != null) {
            return false;
        }
        return this.tagAction != null ? this.tagAction.equals(that.tagAction) : that.tagAction == null;
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (int)(this.userId ^ this.userId >>> 32);
        result = 31 * result + (this.createdDate != null ? this.createdDate.hashCode() : 0);
        result = 31 * result + (this.modifiedDate != null ? this.modifiedDate.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.textCriteria != null ? this.textCriteria.hashCode() : 0);
        result = 31 * result + (this.textCriteriaOperatorType != null ? this.textCriteriaOperatorType.hashCode() : 0);
        result = 31 * result + (this.dateMatchTypeCriteria != null ? this.dateMatchTypeCriteria.hashCode() : 0);
        result = 31 * result + (this.daysLimitCriteria != null ? this.daysLimitCriteria.hashCode() : 0);
        result = 31 * result + (this.amountLimitTypeCriteria != null ? this.amountLimitTypeCriteria.hashCode() : 0);
        result = 31 * result + (this.amountLimitSignCriteria != null ? this.amountLimitSignCriteria.hashCode() : 0);
        result = 31 * result + (this.amountCriteria != null ? this.amountCriteria.hashCode() : 0);
        result = 31 * result + (this.accountCategoryCriteria != null ? this.accountCategoryCriteria.hashCode() : 0);
        result = 31 * result + (this.acceptAction != null ? this.acceptAction.hashCode() : 0);
        result = 31 * result + (this.monthShiftAction != null ? this.monthShiftAction.hashCode() : 0);
        result = 31 * result + (this.removeAction != null ? this.removeAction.hashCode() : 0);
        result = 31 * result + (this.textAction != null ? this.textAction.hashCode() : 0);
        result = 31 * result + (this.commentAction != null ? this.commentAction.hashCode() : 0);
        result = 31 * result + (this.categoryIdAction != null ? this.categoryIdAction.hashCode() : 0);
        result = 31 * result + (this.splitActions != null ? this.splitActions.hashCode() : 0);
        result = 31 * result + (this.flagAction != null ? this.flagAction.hashCode() : 0);
        result = 31 * result + (this.tagAction != null ? this.tagAction.hashCode() : 0);
        return result;
    }

    public long getId() {
        return this.id;
    }

    public long getUserId() {
        return this.userId;
    }

    public boolean getIsAcceptAction() {
        return this.acceptAction;
    }

    public boolean getIsRemoveAction() {
        return this.removeAction;
    }

    public DateTime getCreatedDate() {
        return this.createdDate;
    }

    public DateTime getModifiedDate() {
        return this.modifiedDate;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTextCriteria() {
        return this.textCriteria;
    }

    public void setTextCriteria(String textCriteria) {
        this.textCriteria = textCriteria;
    }

    public TransactionRuleTextCriteriaOperatorType getTextCriteriaOperatorType() {
        return this.textCriteriaOperatorType;
    }

    public void setTextCriteriaOperatorType(TransactionRuleTextCriteriaOperatorType textCriteriaOperatorType) {
        if (this.textCriteriaOperatorType == textCriteriaOperatorType) {
            return;
        }
        this.textCriteriaOperatorType = textCriteriaOperatorType;
    }

    public DateMatchTypeCriteria getDateMatchTypeCriteria() {
        return this.dateMatchTypeCriteria;
    }

    public void setDateMatchTypeCriteria(DateMatchTypeCriteria dateMatchTypeCriteria) {
        if (this.dateMatchTypeCriteria == dateMatchTypeCriteria) {
            return;
        }
        this.dateMatchTypeCriteria = dateMatchTypeCriteria;
    }

    public Integer getDaysLimitCriteria() {
        return this.daysLimitCriteria;
    }

    public void setDaysLimitCriteria(int daysLimitCriteria) {
        this.daysLimitCriteria = daysLimitCriteria;
    }

    public AmountLimitTypeCriteria getAmountLimitTypeCriteria() {
        return this.amountLimitTypeCriteria;
    }

    public void setAmountLimitTypeCriteria(AmountLimitTypeCriteria amountLimitTypeCriteria) {
        if (this.amountLimitTypeCriteria == amountLimitTypeCriteria) {
            return;
        }
        this.amountLimitTypeCriteria = amountLimitTypeCriteria;
    }

    public AmountLimitSignCriteria getAmountLimitSignCriteria() {
        return this.amountLimitSignCriteria;
    }

    public void setAmountLimitSignCriteria(AmountLimitSignCriteria amountLimitSignCriteria) {
        if (this.amountLimitSignCriteria == amountLimitSignCriteria) {
            return;
        }
        this.amountLimitSignCriteria = amountLimitSignCriteria;
    }

    public MenigaDecimal getAmountCriteria() {
        return this.amountCriteria;
    }

    public void setAmountCriteria(MenigaDecimal amountCriteria) {
        this.amountCriteria = amountCriteria;
    }

    public String getAccountCategoryCriteria() {
        return this.accountCategoryCriteria;
    }

    public void setAccountCategoryCriteria(String accountCategoryCriteria) {
        this.accountCategoryCriteria = accountCategoryCriteria;
    }

    public Boolean getAcceptAction() {
        return this.acceptAction;
    }

    public void setAcceptAction(boolean acceptAction) {
        this.acceptAction = acceptAction;
    }

    public Integer getMonthShiftAction() {
        return this.monthShiftAction;
    }

    public void setMonthShiftAction(int monthShiftAction) {
        this.monthShiftAction = monthShiftAction;
    }

    public Boolean getRemoveAction() {
        return this.removeAction;
    }

    public void setRemoveAction(boolean removeAction) {
        this.removeAction = removeAction;
    }

    public String getTextAction() {
        return this.textAction;
    }

    public void setTextAction(String textAction) {
        this.textAction = textAction;
    }

    public String getCommentAction() {
        return this.commentAction;
    }

    public void setCommentAction(String commentAction) {
        this.commentAction = commentAction;
    }

    public Long getCategoryIdAction() {
        return this.categoryIdAction;
    }

    public void setCategoryIdAction(long categoryIdAction) {
        this.categoryIdAction = categoryIdAction;
    }

    public List<SplitAction> getSplitActions() {
        return this.splitActions;
    }

    public void setSplitActions(List<SplitAction> splitActions) {
        if (this.splitActions == null && splitActions == null || this.splitActions.size() == 0 && splitActions.size() == 0) {
            return;
        }
        boolean hasNew = false;
        if (this.splitActions.size() != splitActions.size()) {
            hasNew = true;
        }
        if (!hasNew) {
            block0: for (SplitAction action : this.splitActions) {
                for (SplitAction action2 : splitActions) {
                    if (action2.equals(action)) continue;
                    hasNew = true;
                    continue block0;
                }
            }
        }
        if (!hasNew) {
            return;
        }
        this.splitActions = splitActions;
    }

    public Boolean getFlagAction() {
        return this.flagAction;
    }

    public void setFlagAction(Boolean flagAction) {
        this.flagAction = flagAction;
    }

    public String getTagAction() {
        return this.tagAction;
    }

    public Result<Void> delete() {
        return apiOperator.deleteTransactionRule(this.id);
    }

    public Result<Void> update(boolean applyOnExisting) {
        return apiOperator.updateTransactionRule(this.id, this.name, this.textCriteria, this.textCriteriaOperatorType, this.dateMatchTypeCriteria, this.daysLimitCriteria, this.amountLimitTypeCriteria, this.amountLimitSignCriteria, this.amountCriteria, this.accountCategoryCriteria, this.acceptAction, this.monthShiftAction, this.removeAction, this.textAction, this.commentAction, this.categoryIdAction, this.splitActions, this.flagAction, applyOnExisting);
    }

    public Result<MenigaTransactionRule> refresh() {
        Result<MenigaTransactionRule> task2 = MenigaTransactionRule.fetch(this.id);
        return MenigaSDK.getMenigaSettings().getTaskAdapter().intercept(task2, new Interceptor<MenigaTransactionRule>(){

            @Override
            public void onFinished(MenigaTransactionRule result, boolean failed) {
                if (failed || result == null) {
                    return;
                }
                try {
                    Merge.merge(MenigaTransactionRule.this, result);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static Result<List<MenigaTransactionRule>> fetch() {
        return apiOperator.getTransactionRules();
    }

    public static Result<MenigaTransactionRule> create(String name, String textCriteria, TransactionRuleTextCriteriaOperatorType textCriteriaOperatorType, DateMatchTypeCriteria dateMatchTypeCriteria, Integer daysLimitCriteria, AmountLimitTypeCriteria amountLimitTypeCriteria, AmountLimitSignCriteria amountLimitSignCriteria, MenigaDecimal amountCriteria, String accountCategoryCriteria, Boolean acceptAction, Integer monthShiftAction, Boolean removeAction, String textAction, String commentAction, Long categoryIdAction, List<SplitAction> splitActions, Boolean flagAction) {
        return apiOperator.createTransactionRule(name, textCriteria, textCriteriaOperatorType, dateMatchTypeCriteria, daysLimitCriteria, amountLimitTypeCriteria, amountLimitSignCriteria, amountCriteria, accountCategoryCriteria, acceptAction, monthShiftAction, removeAction, textAction, commentAction, categoryIdAction, splitActions, flagAction);
    }

    public static Result<MenigaTransactionRule> fetch(long id) {
        return apiOperator.getTransactionRule(id);
    }

    public static class SplitAction
    implements Serializable,
    Parcelable {
        public static final Parcelable.Creator<SplitAction> CREATOR = new Parcelable.Creator<SplitAction>(){

            public SplitAction createFromParcel(Parcel source) {
                return new SplitAction(source);
            }

            public SplitAction[] newArray(int size) {
                return new SplitAction[size];
            }
        };
        public long id;
        public long transactionRuleId;
        public MenigaDecimal ratio;
        public MenigaDecimal amount;
        public long categoryId;

        protected SplitAction() {
        }

        protected SplitAction(Parcel in) {
            this.id = in.readLong();
            this.transactionRuleId = in.readLong();
            this.ratio = (MenigaDecimal)in.readSerializable();
            this.amount = (MenigaDecimal)in.readSerializable();
            this.categoryId = in.readLong();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SplitAction that = (SplitAction)o;
            if (this.id != that.id) {
                return false;
            }
            if (this.transactionRuleId != that.transactionRuleId) {
                return false;
            }
            if (this.categoryId != that.categoryId) {
                return false;
            }
            if (this.ratio != null ? !this.ratio.equals(that.ratio) : that.ratio != null) {
                return false;
            }
            return this.amount != null ? this.amount.equals(that.amount) : that.amount == null;
        }

        public int hashCode() {
            int result = (int)(this.id ^ this.id >>> 32);
            result = 31 * result + (int)(this.transactionRuleId ^ this.transactionRuleId >>> 32);
            result = 31 * result + (this.ratio != null ? this.ratio.hashCode() : 0);
            result = 31 * result + (this.amount != null ? this.amount.hashCode() : 0);
            result = 31 * result + (int)(this.categoryId ^ this.categoryId >>> 32);
            return result;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeLong(this.id);
            dest.writeLong(this.transactionRuleId);
            dest.writeSerializable((Serializable)this.ratio);
            dest.writeSerializable((Serializable)this.amount);
            dest.writeLong(this.categoryId);
        }
    }
}

