/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.transactions;

import android.os.Parcel;
import android.os.Parcelable;
import com.meniga.sdk.MenigaSDK;
import com.meniga.sdk.helpers.Interceptor;
import com.meniga.sdk.helpers.MTask;
import com.meniga.sdk.helpers.MenigaDecimal;
import com.meniga.sdk.helpers.Result;
import com.meniga.sdk.models.Merge;
import com.meniga.sdk.models.accounts.MenigaAccount;
import com.meniga.sdk.models.categories.MenigaCategoryScore;
import com.meniga.sdk.models.feed.MenigaFeedItem;
import com.meniga.sdk.models.merchants.MenigaMerchant;
import com.meniga.sdk.models.transactions.MenigaComment;
import com.meniga.sdk.models.transactions.MenigaTransactionPage;
import com.meniga.sdk.models.transactions.MenigaTransactionUpdate;
import com.meniga.sdk.models.transactions.ParsedData;
import com.meniga.sdk.models.transactions.TransactionsFilter;
import com.meniga.sdk.models.transactions.operators.MenigaTransactionOperations;
import com.meniga.sdk.providers.tasks.Continuation;
import com.meniga.sdk.providers.tasks.Task;
import com.meniga.sdk.providers.tasks.TaskCompletionSource;
import com.meniga.sdk.webservices.requests.UpdateSplits;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class MenigaTransaction
implements Serializable,
MenigaFeedItem,
Cloneable,
Parcelable {
    protected static MenigaTransactionOperations apiOperator;
    protected String parentIdentifier;
    protected long id;
    protected MenigaDecimal amount;
    protected MenigaDecimal bookedAmount;
    protected List<String> tags;
    protected List<MenigaComment> comments = new ArrayList<MenigaComment>();
    protected Long categoryId;
    protected DateTime date;
    protected String text;
    protected DateTime originalDate;
    protected String originalText;
    protected MenigaDecimal originalAmount;
    protected Boolean isRead;
    protected Boolean isFlagged;
    protected boolean hasUncertainCategorization;
    protected Long accountId;
    protected MenigaAccount account;
    protected Integer mcc;
    protected List<MenigaCategoryScore> detectedCategories;
    protected String currency;
    protected MenigaDecimal amountInCurrency;
    protected Integer dataFormat;
    protected Long merchantId;
    protected MenigaMerchant merchant;
    protected List<MenigaMerchant> merchants;
    protected String bankId;
    protected DateTime insertTime;
    protected Boolean hasUserClearedCategoryUncertainty;
    protected Boolean isUncleared;
    protected MenigaDecimal balance;
    protected DateTime categoryChangedTime;
    protected Long changedByRule;
    protected DateTime changedByRuleTime;
    protected String counterpartyAccountIdentifier;
    protected DateTime dueDate;
    protected DateTime lastModifiedTime;
    protected DateTime timestamp;
    protected List<ParsedData> parsedData;
    protected String data;
    protected MenigaDecimal redeemed;
    protected MenigaDecimal toRedeem;
    protected MenigaDecimal remainingToSpend;
    protected Boolean belongsToExpiredOffer;
    protected String reason;
    protected Boolean isSplitChild;
    protected long timeStamp;
    protected String userData;
    protected String eventTypeIdentifier;
    protected String topicName;
    public static final Parcelable.Creator<MenigaTransaction> CREATOR;

    protected MenigaTransaction() {
    }

    public static void setOperator(MenigaTransactionOperations operator) {
        apiOperator = operator;
    }

    public long getId() {
        return this.id;
    }

    public String getParentIdentifier() {
        return this.parentIdentifier;
    }

    public String getText() {
        return this.text;
    }

    public MenigaDecimal getAmount() {
        return this.amount;
    }

    public MenigaDecimal getBookedAmount() {
        return this.bookedAmount;
    }

    public void setAmount(MenigaDecimal amount) {
        this.amount = amount;
    }

    public Long getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(long categoryId) {
        this.categoryId = categoryId;
    }

    public List<MenigaComment> getComments() {
        if (this.comments == null) {
            this.comments = new ArrayList<MenigaComment>();
        }
        return this.comments;
    }

    @Override
    public DateTime getDate() {
        return this.date;
    }

    public void setDate(DateTime date) {
        this.date = date;
    }

    public Boolean getIsRead() {
        return this.isRead;
    }

    public void setIsRead(boolean isRead) {
        this.isRead = isRead;
    }

    public void setIsReadAndUpdate() {
        this.setIsRead(true);
        this.update();
    }

    public Boolean getIsFlagged() {
        return this.isFlagged;
    }

    public void setIsFlagged(boolean isFlagged) {
        this.isFlagged = isFlagged;
    }

    public boolean getHasUncertainCategorization() {
        return this.hasUncertainCategorization;
    }

    public void setHasUncertainCategorization(boolean uncertain) {
        this.hasUncertainCategorization = uncertain;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public DateTime getOriginalDate() {
        return this.originalDate;
    }

    @Override
    public String getEventTypeIdentifier() {
        return this.eventTypeIdentifier;
    }

    @Override
    public String getTopicName() {
        return this.topicName;
    }

    public String getOriginalText() {
        return this.originalText;
    }

    public MenigaDecimal getOriginalAmount() {
        return this.originalAmount;
    }

    public Long getAccountId() {
        return this.accountId;
    }

    public MenigaAccount getAccount() {
        return this.account;
    }

    public Integer getMcc() {
        return this.mcc;
    }

    public List<MenigaCategoryScore> getDetectedCategories() {
        return this.detectedCategories;
    }

    public String getCurrency() {
        return this.currency;
    }

    public MenigaDecimal getAmountInCurrency() {
        return this.amountInCurrency;
    }

    public Integer getDataFormat() {
        return this.dataFormat;
    }

    public Long getMerchantId() {
        return this.merchantId;
    }

    public MenigaMerchant getMerchant() {
        return this.merchant;
    }

    public List<MenigaMerchant> getMerchants() {
        return this.merchants;
    }

    public String getBankId() {
        return this.bankId;
    }

    public DateTime getInsertTime() {
        return this.insertTime;
    }

    public Boolean getHasUserClearedCategoryUncertainty() {
        return this.hasUserClearedCategoryUncertainty;
    }

    public Boolean getIsUncleared() {
        return this.isUncleared;
    }

    public MenigaDecimal getBalance() {
        return this.balance;
    }

    public DateTime getCategoryChangedTime() {
        return this.categoryChangedTime;
    }

    public Long getChangedByRule() {
        return this.changedByRule;
    }

    public DateTime getChangedByRuleTime() {
        return this.changedByRuleTime;
    }

    public String getCounterpartyAccountIdentifier() {
        return this.counterpartyAccountIdentifier;
    }

    public DateTime getDueDate() {
        return this.dueDate;
    }

    public DateTime getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public List<ParsedData> getParsedData() {
        return this.parsedData;
    }

    public String getData() {
        return this.data;
    }

    public MenigaDecimal getRedeemed() {
        return this.redeemed;
    }

    public MenigaDecimal getToRedeem() {
        return this.toRedeem;
    }

    public MenigaDecimal getRemainingToSpend() {
        return this.remainingToSpend;
    }

    public Boolean getBelongsToExpiredOffer() {
        return this.belongsToExpiredOffer;
    }

    public String getReason() {
        return this.reason;
    }

    public boolean getIsSplitChild() {
        if (this.isSplitChild == null) {
            return false;
        }
        return this.isSplitChild;
    }

    public boolean getIsSplitParent() {
        if (this.isSplitChild == null) {
            return false;
        }
        return this.isSplitChild == false;
    }

    public void setIsSplitParent(boolean splitParent) {
        if (!splitParent) {
            this.isSplitChild = null;
            return;
        }
        this.isSplitChild = false;
    }

    public boolean getIsSplit() {
        return this.isSplitChild != null;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.parentIdentifier);
        dest.writeLong(this.id);
        dest.writeSerializable((Serializable)this.amount);
        dest.writeSerializable((Serializable)this.bookedAmount);
        dest.writeStringList(this.tags);
        dest.writeTypedList(this.comments);
        dest.writeValue((Object)this.categoryId);
        dest.writeSerializable((Serializable)this.date);
        dest.writeString(this.text);
        dest.writeSerializable((Serializable)this.originalDate);
        dest.writeString(this.originalText);
        dest.writeSerializable((Serializable)this.originalAmount);
        dest.writeValue((Object)this.isRead);
        dest.writeValue((Object)this.isFlagged);
        dest.writeByte(this.hasUncertainCategorization ? (byte)1 : 0);
        dest.writeValue((Object)this.accountId);
        dest.writeParcelable((Parcelable)this.account, flags);
        dest.writeValue((Object)this.mcc);
        dest.writeTypedList(this.detectedCategories);
        dest.writeString(this.currency);
        dest.writeSerializable((Serializable)this.amountInCurrency);
        dest.writeValue((Object)this.dataFormat);
        dest.writeValue((Object)this.merchantId);
        dest.writeParcelable((Parcelable)this.merchant, flags);
        dest.writeTypedList(this.merchants);
        dest.writeString(this.bankId);
        dest.writeSerializable((Serializable)this.insertTime);
        dest.writeValue((Object)this.hasUserClearedCategoryUncertainty);
        dest.writeValue((Object)this.isUncleared);
        dest.writeSerializable((Serializable)this.balance);
        dest.writeSerializable((Serializable)this.categoryChangedTime);
        dest.writeValue((Object)this.changedByRule);
        dest.writeSerializable((Serializable)this.changedByRuleTime);
        dest.writeString(this.counterpartyAccountIdentifier);
        dest.writeSerializable((Serializable)this.dueDate);
        dest.writeSerializable((Serializable)this.lastModifiedTime);
        dest.writeSerializable((Serializable)this.timestamp);
        dest.writeTypedList(this.parsedData);
        dest.writeString(this.data);
        dest.writeSerializable((Serializable)this.redeemed);
        dest.writeSerializable((Serializable)this.toRedeem);
        dest.writeSerializable((Serializable)this.remainingToSpend);
        dest.writeValue((Object)this.belongsToExpiredOffer);
        dest.writeString(this.reason);
        dest.writeValue((Object)this.isSplitChild);
        dest.writeLong(this.timeStamp);
        dest.writeString(this.userData);
        dest.writeString(this.eventTypeIdentifier);
        dest.writeString(this.topicName);
    }

    protected MenigaTransaction(Parcel in) {
        this.parentIdentifier = in.readString();
        this.id = in.readLong();
        this.amount = (MenigaDecimal)in.readSerializable();
        this.bookedAmount = (MenigaDecimal)in.readSerializable();
        this.tags = in.createStringArrayList();
        this.comments = in.createTypedArrayList(MenigaComment.CREATOR);
        this.categoryId = (Long)in.readValue(Long.class.getClassLoader());
        this.date = (DateTime)in.readSerializable();
        this.text = in.readString();
        this.originalDate = (DateTime)in.readSerializable();
        this.originalText = in.readString();
        this.originalAmount = (MenigaDecimal)in.readSerializable();
        this.isRead = (Boolean)in.readValue(Boolean.class.getClassLoader());
        this.isFlagged = (Boolean)in.readValue(Boolean.class.getClassLoader());
        this.hasUncertainCategorization = in.readByte() != 0;
        this.accountId = (Long)in.readValue(Long.class.getClassLoader());
        this.account = (MenigaAccount)in.readParcelable(MenigaAccount.class.getClassLoader());
        this.mcc = (Integer)in.readValue(Integer.class.getClassLoader());
        this.detectedCategories = in.createTypedArrayList(MenigaCategoryScore.CREATOR);
        this.currency = in.readString();
        this.amountInCurrency = (MenigaDecimal)in.readSerializable();
        this.dataFormat = (Integer)in.readValue(Integer.class.getClassLoader());
        this.merchantId = (Long)in.readValue(Long.class.getClassLoader());
        this.merchant = (MenigaMerchant)in.readParcelable(MenigaMerchant.class.getClassLoader());
        this.merchants = in.createTypedArrayList(MenigaMerchant.CREATOR);
        this.bankId = in.readString();
        this.insertTime = (DateTime)in.readSerializable();
        this.hasUserClearedCategoryUncertainty = (Boolean)in.readValue(Boolean.class.getClassLoader());
        this.isUncleared = (Boolean)in.readValue(Boolean.class.getClassLoader());
        this.balance = (MenigaDecimal)in.readSerializable();
        this.categoryChangedTime = (DateTime)in.readSerializable();
        this.changedByRule = (Long)in.readValue(Long.class.getClassLoader());
        this.changedByRuleTime = (DateTime)in.readSerializable();
        this.counterpartyAccountIdentifier = in.readString();
        this.dueDate = (DateTime)in.readSerializable();
        this.lastModifiedTime = (DateTime)in.readSerializable();
        this.timestamp = (DateTime)in.readSerializable();
        this.parsedData = in.createTypedArrayList(ParsedData.CREATOR);
        this.data = in.readString();
        this.redeemed = (MenigaDecimal)in.readSerializable();
        this.toRedeem = (MenigaDecimal)in.readSerializable();
        this.remainingToSpend = (MenigaDecimal)in.readSerializable();
        this.belongsToExpiredOffer = (Boolean)in.readValue(Boolean.class.getClassLoader());
        this.reason = in.readString();
        this.isSplitChild = (Boolean)in.readValue(Boolean.class.getClassLoader());
        this.timeStamp = in.readLong();
        this.userData = in.readString();
        this.eventTypeIdentifier = in.readString();
        this.topicName = in.readString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MenigaTransaction that = (MenigaTransaction)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.hasUncertainCategorization != that.hasUncertainCategorization) {
            return false;
        }
        if (this.timeStamp != that.timeStamp) {
            return false;
        }
        if (this.parentIdentifier != null ? !this.parentIdentifier.equals(that.parentIdentifier) : that.parentIdentifier != null) {
            return false;
        }
        if (this.amount != null ? !this.amount.equals(that.amount) : that.amount != null) {
            return false;
        }
        if (this.bookedAmount != null ? !this.bookedAmount.equals(that.bookedAmount) : that.bookedAmount != null) {
            return false;
        }
        if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) {
            return false;
        }
        if (this.comments != null ? !this.comments.equals(that.comments) : that.comments != null) {
            return false;
        }
        if (this.categoryId != null ? !this.categoryId.equals(that.categoryId) : that.categoryId != null) {
            return false;
        }
        if (this.date != null ? !this.date.equals((Object)that.date) : that.date != null) {
            return false;
        }
        if (this.text != null ? !this.text.equals(that.text) : that.text != null) {
            return false;
        }
        if (this.originalDate != null ? !this.originalDate.equals((Object)that.originalDate) : that.originalDate != null) {
            return false;
        }
        if (this.originalText != null ? !this.originalText.equals(that.originalText) : that.originalText != null) {
            return false;
        }
        if (this.originalAmount != null ? !this.originalAmount.equals(that.originalAmount) : that.originalAmount != null) {
            return false;
        }
        if (this.isRead != null ? !this.isRead.equals(that.isRead) : that.isRead != null) {
            return false;
        }
        if (this.isFlagged != null ? !this.isFlagged.equals(that.isFlagged) : that.isFlagged != null) {
            return false;
        }
        if (this.accountId != null ? !this.accountId.equals(that.accountId) : that.accountId != null) {
            return false;
        }
        if (this.mcc != null ? !this.mcc.equals(that.mcc) : that.mcc != null) {
            return false;
        }
        if (this.detectedCategories != null ? !this.detectedCategories.equals(that.detectedCategories) : that.detectedCategories != null) {
            return false;
        }
        if (this.currency != null ? !this.currency.equals(that.currency) : that.currency != null) {
            return false;
        }
        if (this.amountInCurrency != null ? !this.amountInCurrency.equals(that.amountInCurrency) : that.amountInCurrency != null) {
            return false;
        }
        if (this.dataFormat != null ? !this.dataFormat.equals(that.dataFormat) : that.dataFormat != null) {
            return false;
        }
        if (this.merchantId != null ? !this.merchantId.equals(that.merchantId) : that.merchantId != null) {
            return false;
        }
        if (this.merchants != null ? !this.merchants.equals(that.merchants) : that.merchants != null) {
            return false;
        }
        if (this.bankId != null ? !this.bankId.equals(that.bankId) : that.bankId != null) {
            return false;
        }
        if (this.insertTime != null ? !this.insertTime.equals((Object)that.insertTime) : that.insertTime != null) {
            return false;
        }
        if (this.hasUserClearedCategoryUncertainty != null ? !this.hasUserClearedCategoryUncertainty.equals(that.hasUserClearedCategoryUncertainty) : that.hasUserClearedCategoryUncertainty != null) {
            return false;
        }
        if (this.isUncleared != null ? !this.isUncleared.equals(that.isUncleared) : that.isUncleared != null) {
            return false;
        }
        if (this.balance != null ? !this.balance.equals(that.balance) : that.balance != null) {
            return false;
        }
        if (this.categoryChangedTime != null ? !this.categoryChangedTime.equals((Object)that.categoryChangedTime) : that.categoryChangedTime != null) {
            return false;
        }
        if (this.changedByRule != null ? !this.changedByRule.equals(that.changedByRule) : that.changedByRule != null) {
            return false;
        }
        if (this.changedByRuleTime != null ? !this.changedByRuleTime.equals((Object)that.changedByRuleTime) : that.changedByRuleTime != null) {
            return false;
        }
        if (this.counterpartyAccountIdentifier != null ? !this.counterpartyAccountIdentifier.equals(that.counterpartyAccountIdentifier) : that.counterpartyAccountIdentifier != null) {
            return false;
        }
        if (this.dueDate != null ? !this.dueDate.equals((Object)that.dueDate) : that.dueDate != null) {
            return false;
        }
        if (this.lastModifiedTime != null ? !this.lastModifiedTime.equals((Object)that.lastModifiedTime) : that.lastModifiedTime != null) {
            return false;
        }
        if (this.timestamp != null ? !this.timestamp.equals((Object)that.timestamp) : that.timestamp != null) {
            return false;
        }
        if (this.parsedData != null ? !this.parsedData.equals(that.parsedData) : that.parsedData != null) {
            return false;
        }
        if (this.data != null ? !this.data.equals(that.data) : that.data != null) {
            return false;
        }
        if (this.redeemed != null ? !this.redeemed.equals(that.redeemed) : that.redeemed != null) {
            return false;
        }
        if (this.toRedeem != null ? !this.toRedeem.equals(that.toRedeem) : that.toRedeem != null) {
            return false;
        }
        if (this.remainingToSpend != null ? !this.remainingToSpend.equals(that.remainingToSpend) : that.remainingToSpend != null) {
            return false;
        }
        if (this.belongsToExpiredOffer != null ? !this.belongsToExpiredOffer.equals(that.belongsToExpiredOffer) : that.belongsToExpiredOffer != null) {
            return false;
        }
        if (this.reason != null ? !this.reason.equals(that.reason) : that.reason != null) {
            return false;
        }
        if (this.isSplitChild != null ? !this.isSplitChild.equals(that.isSplitChild) : that.isSplitChild != null) {
            return false;
        }
        if (this.userData != null ? !this.userData.equals(that.userData) : that.userData != null) {
            return false;
        }
        if (this.eventTypeIdentifier != null ? !this.eventTypeIdentifier.equals(that.eventTypeIdentifier) : that.eventTypeIdentifier != null) {
            return false;
        }
        return this.topicName != null ? this.topicName.equals(that.topicName) : that.topicName == null;
    }

    public int hashCode() {
        int result = this.parentIdentifier != null ? this.parentIdentifier.hashCode() : 0;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.amount != null ? this.amount.hashCode() : 0);
        result = 31 * result + (this.bookedAmount != null ? this.bookedAmount.hashCode() : 0);
        result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
        result = 31 * result + (this.comments != null ? this.comments.hashCode() : 0);
        result = 31 * result + (this.categoryId != null ? this.categoryId.hashCode() : 0);
        result = 31 * result + (this.date != null ? this.date.hashCode() : 0);
        result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
        result = 31 * result + (this.originalDate != null ? this.originalDate.hashCode() : 0);
        result = 31 * result + (this.originalText != null ? this.originalText.hashCode() : 0);
        result = 31 * result + (this.originalAmount != null ? this.originalAmount.hashCode() : 0);
        result = 31 * result + (this.isRead != null ? this.isRead.hashCode() : 0);
        result = 31 * result + (this.isFlagged != null ? this.isFlagged.hashCode() : 0);
        result = 31 * result + (this.hasUncertainCategorization ? 1 : 0);
        result = 31 * result + (this.accountId != null ? this.accountId.hashCode() : 0);
        result = 31 * result + (this.mcc != null ? this.mcc.hashCode() : 0);
        result = 31 * result + (this.detectedCategories != null ? this.detectedCategories.hashCode() : 0);
        result = 31 * result + (this.currency != null ? this.currency.hashCode() : 0);
        result = 31 * result + (this.amountInCurrency != null ? this.amountInCurrency.hashCode() : 0);
        result = 31 * result + (this.dataFormat != null ? this.dataFormat.hashCode() : 0);
        result = 31 * result + (this.merchantId != null ? this.merchantId.hashCode() : 0);
        result = 31 * result + (this.bankId != null ? this.bankId.hashCode() : 0);
        result = 31 * result + (this.insertTime != null ? this.insertTime.hashCode() : 0);
        result = 31 * result + (this.hasUserClearedCategoryUncertainty != null ? this.hasUserClearedCategoryUncertainty.hashCode() : 0);
        result = 31 * result + (this.isUncleared != null ? this.isUncleared.hashCode() : 0);
        result = 31 * result + (this.balance != null ? this.balance.hashCode() : 0);
        result = 31 * result + (this.categoryChangedTime != null ? this.categoryChangedTime.hashCode() : 0);
        result = 31 * result + (this.changedByRule != null ? this.changedByRule.hashCode() : 0);
        result = 31 * result + (this.changedByRuleTime != null ? this.changedByRuleTime.hashCode() : 0);
        result = 31 * result + (this.counterpartyAccountIdentifier != null ? this.counterpartyAccountIdentifier.hashCode() : 0);
        result = 31 * result + (this.dueDate != null ? this.dueDate.hashCode() : 0);
        result = 31 * result + (this.lastModifiedTime != null ? this.lastModifiedTime.hashCode() : 0);
        result = 31 * result + (this.timestamp != null ? this.timestamp.hashCode() : 0);
        result = 31 * result + (this.parsedData != null ? this.parsedData.hashCode() : 0);
        result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
        result = 31 * result + (this.userData != null ? this.userData.hashCode() : 0);
        result = 31 * result + (this.redeemed != null ? this.redeemed.hashCode() : 0);
        result = 31 * result + (this.toRedeem != null ? this.toRedeem.hashCode() : 0);
        result = 31 * result + (this.remainingToSpend != null ? this.remainingToSpend.hashCode() : 0);
        result = 31 * result + (this.belongsToExpiredOffer != null ? this.belongsToExpiredOffer.hashCode() : 0);
        result = 31 * result + (this.reason != null ? this.reason.hashCode() : 0);
        result = 31 * result + (this.isSplitChild == null ? 2 : (this.isSplitChild != false ? 1 : 0));
        result = 31 * result + (int)(this.timeStamp ^ this.timeStamp >>> 32);
        result = 31 * result + (int)(this.timeStamp ^ this.timeStamp >>> 32);
        return result;
    }

    @Override
    public MenigaTransaction clone() throws CloneNotSupportedException {
        return (MenigaTransaction)super.clone();
    }

    public String getUserData() {
        return this.userData;
    }

    public void setUserData(String data) {
        this.userData = data;
    }

    public String toString() {
        return Long.toString(this.id) + ": " + this.amount.doubleValue() + ": " + this.text + " (" + this.date.toString() + ")";
    }

    public Result<MenigaTransactionUpdate> update() {
        return apiOperator.updateTransaction(this);
    }

    public Result<Void> delete() {
        return apiOperator.deleteTransaction(this.id);
    }

    public Result<List<MenigaTransaction>> fetchSplitChildren() {
        Result<List<MenigaTransaction>> task2 = apiOperator.fetchSplitTransactions(this);
        if (this.isSplitChild != null && this.isSplitChild.booleanValue()) {
            return MenigaSDK.getMenigaSettings().getTaskAdapter().intercept(task2, new Interceptor<List<MenigaTransaction>>(){

                @Override
                public void onFinished(List<MenigaTransaction> result, boolean failed) {
                    if (!failed && result != null) {
                        result.clear();
                    }
                }
            });
        }
        return MenigaSDK.getMenigaSettings().getTaskAdapter().intercept(task2, new Interceptor<List<MenigaTransaction>>(){

            @Override
            public void onFinished(List<MenigaTransaction> result, boolean failed) {
                if (failed || result == null) {
                    return;
                }
                ArrayList<MenigaTransaction> toReturn = new ArrayList<MenigaTransaction>();
                for (MenigaTransaction trans : result) {
                    if (trans.getId() == MenigaTransaction.this.getId()) continue;
                    toReturn.add(trans);
                }
                Collections.sort(toReturn, new Comparator<MenigaTransaction>(){

                    @Override
                    public int compare(MenigaTransaction lhs, MenigaTransaction rhs) {
                        return lhs.date.compareTo((ReadableInstant)rhs.date);
                    }
                });
                result.clear();
                result.addAll(toReturn);
            }
        });
    }

    public Result<List<MenigaTransaction>> fetchSplitParent() {
        Result<List<MenigaTransaction>> task2 = apiOperator.fetchSplitTransactions(this);
        if (this.isSplitChild != null && !this.isSplitChild.booleanValue()) {
            return MenigaSDK.getMenigaSettings().getTaskAdapter().intercept(task2, new Interceptor<List<MenigaTransaction>>(){

                @Override
                public void onFinished(List<MenigaTransaction> result, boolean failed) {
                    if (!failed && result != null) {
                        result.clear();
                    }
                }
            });
        }
        return MenigaSDK.getMenigaSettings().getTaskAdapter().intercept(task2, new Interceptor<List<MenigaTransaction>>(){

            @Override
            public void onFinished(List<MenigaTransaction> result, boolean failed) {
                if (!failed && result != null) {
                    MenigaTransaction parent = null;
                    for (MenigaTransaction trans : result) {
                        if (trans.isSplitChild == null || trans.isSplitChild.booleanValue()) continue;
                        parent = trans;
                        break;
                    }
                    result.clear();
                    result.add(parent);
                }
            }
        });
    }

    public Result<List<MenigaTransaction>> fetchSplitAndParent() {
        Result<List<MenigaTransaction>> task2 = apiOperator.fetchSplitTransactions(this);
        return MenigaSDK.getMenigaSettings().getTaskAdapter().intercept(task2, new Interceptor<List<MenigaTransaction>>(){

            @Override
            public void onFinished(List<MenigaTransaction> result, boolean failed) {
                if (failed || result == null) {
                    return;
                }
                ArrayList<MenigaTransaction> sortedResult = new ArrayList<MenigaTransaction>();
                MenigaTransaction parent = null;
                for (MenigaTransaction trans : result) {
                    if (trans.isSplitChild != null && trans.isSplitChild.booleanValue()) {
                        sortedResult.add(trans);
                        continue;
                    }
                    parent = trans;
                }
                Collections.sort(sortedResult, new Comparator<MenigaTransaction>(){

                    @Override
                    public int compare(MenigaTransaction lhs, MenigaTransaction rhs) {
                        return lhs.date.compareTo((ReadableInstant)rhs.date);
                    }
                });
                sortedResult.add(0, parent);
                result.clear();
                result.addAll(sortedResult);
            }
        });
    }

    public Result<List<MenigaTransaction>> split(MenigaDecimal amount, String text, long categoryId, boolean isFlagged) {
        Result<List<MenigaTransaction>> task2 = apiOperator.splitTransaction(this.id, amount, text, categoryId, isFlagged);
        return MenigaSDK.getMenigaSettings().getTaskAdapter().intercept(task2, new Interceptor<List<MenigaTransaction>>(){

            @Override
            public void onFinished(List<MenigaTransaction> result, boolean failed) {
                if (failed || result == null) {
                    return;
                }
                MenigaTransaction.this.isSplitChild = false;
            }
        });
    }

    public Result<List<MenigaTransaction>> updateSplits(List<UpdateSplits> update) {
        return apiOperator.updateSplits(this.id, update);
    }

    public Result<MenigaTransaction> refresh() {
        Result<MenigaTransaction> task2 = MenigaTransaction.fetch(this.id);
        return MenigaSDK.getMenigaSettings().getTaskAdapter().intercept(task2, new Interceptor<MenigaTransaction>(){

            @Override
            public void onFinished(MenigaTransaction result, boolean failed) {
                if (failed || result == null) {
                    return;
                }
                try {
                    Merge.merge(MenigaTransaction.this, result);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static Result<MenigaTransactionUpdate> update(List<Long> transToUpdate, MenigaDecimal amount, Long categoryId, boolean hasUncertainCategorization, Boolean useSubTextInRecat, String text, DateTime date, Boolean isRead, Boolean isFlagged, String userData) {
        return apiOperator.updateTransactions(transToUpdate, amount, categoryId, hasUncertainCategorization, useSubTextInRecat, text, date, isRead, isFlagged, userData);
    }

    public static Result<MenigaTransactionPage> fetch(List<TransactionsFilter> filters) {
        if (filters == null || filters.size() == 0) {
            return MenigaTransaction.fetch(new TransactionsFilter.Builder().build());
        }
        if (filters.size() == 1) {
            return MenigaTransaction.fetch(filters.get(0));
        }
        final TaskCompletionSource src = new TaskCompletionSource();
        Task task2 = src.getTask();
        ArrayList<Task<MenigaTransactionPage>> transactionTasks = new ArrayList<Task<MenigaTransactionPage>>();
        for (TransactionsFilter filter : filters) {
            transactionTasks.add(MenigaTransaction.fetch(filter).getTask());
        }
        Task.whenAllResult(transactionTasks).continueWith(new Continuation<List<MenigaTransactionPage>, Void>(){

            @Override
            public Void then(Task<List<MenigaTransactionPage>> task2) throws Exception {
                MenigaTransactionPage page = new MenigaTransactionPage();
                if (!task2.isFaulted()) {
                    for (MenigaTransactionPage subPage : task2.getResult()) {
                        for (MenigaTransaction sub : subPage) {
                            boolean exists = false;
                            for (MenigaTransaction item : page) {
                                if (item.getId() != sub.getId()) continue;
                                exists = true;
                                break;
                            }
                            if (exists) continue;
                            page.add(sub);
                        }
                    }
                    Collections.sort(page, new Comparator<MenigaTransaction>(){

                        @Override
                        public int compare(MenigaTransaction left, MenigaTransaction right) {
                            if (left == null || left.getDate() == null) {
                                return 1;
                            }
                            if (right == null || right.getDate() == null) {
                                return -1;
                            }
                            return right.getDate().compareTo((ReadableInstant)left.getDate());
                        }
                    });
                }
                src.setResult(page);
                return null;
            }
        });
        return new MTask<MenigaTransactionPage>(task2, src);
    }

    public static Result<MenigaTransactionPage> fetch(final TransactionsFilter transFilter) {
        Result<MenigaTransactionPage> task2 = apiOperator.getTransactions(transFilter);
        return MenigaSDK.getMenigaSettings().getTaskAdapter().intercept(task2, new Interceptor<MenigaTransactionPage>(){

            @Override
            public void onFinished(MenigaTransactionPage result, boolean failed) {
                if (failed || result == null) {
                    return;
                }
                if (transFilter.getNumItemsPerPage() != null) {
                    result.setNumItemsPerPage(transFilter.getNumItemsPerPage());
                }
                if (transFilter.getPage() != null) {
                    result.setPage(transFilter.getPage());
                }
            }
        });
    }

    public static Result<MenigaTransaction> fetch(long transactionId) {
        return apiOperator.getTransaction(transactionId);
    }

    public static Result<MenigaTransaction> create(DateTime date, String text, MenigaDecimal amount, long categoryId) {
        return apiOperator.createTransaction(date, text, amount, categoryId);
    }

    public static Result<Void> deleteTransactions(List<Long> transactionIds) {
        return apiOperator.deleteTransactions(transactionIds);
    }

    public static Result<Void> recategorize(List<String> transactionTexts, Boolean recategorizeUnreadOnly, Boolean useSubTextInRecat, Boolean markAsRead) {
        return apiOperator.recategorize(transactionTexts, recategorizeUnreadOnly, useSubTextInRecat, markAsRead);
    }

    public static Result<List<MenigaComment>> addComments(List<Long> transactionIds, String comment) {
        return apiOperator.addComments(transactionIds, comment);
    }

    static {
        CREATOR = new Parcelable.Creator<MenigaTransaction>(){

            public MenigaTransaction createFromParcel(Parcel source) {
                return new MenigaTransaction(source);
            }

            public MenigaTransaction[] newArray(int size) {
                return new MenigaTransaction[size];
            }
        };
    }
}

