/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.terms;

import android.os.Parcel;
import android.os.Parcelable;
import com.meniga.sdk.MenigaSDK;
import com.meniga.sdk.helpers.Result;
import com.meniga.sdk.models.terms.MenigaTermType;
import com.meniga.sdk.models.terms.TermsState;
import com.meniga.sdk.models.terms.TermsType;
import com.meniga.sdk.models.terms.operators.MenigaTermsOperations;
import java.io.Serializable;
import java.util.List;
import org.joda.time.DateTime;

public class MenigaTerms
implements Parcelable,
Serializable,
Cloneable {
    protected static MenigaTermsOperations apiOperator;
    protected DateTime creationDate;
    protected String content;
    protected String culture;
    protected Boolean acceptanceRequired;
    protected TermsType termsAndConditionsType;
    protected TermsState termsAndConditionsState;
    protected DateTime modifiedAt;
    public static final Parcelable.Creator<MenigaTerms> CREATOR;

    public DateTime getCreationDate() {
        return this.creationDate;
    }

    public String getContent() {
        return this.content;
    }

    public String getCulture() {
        return this.culture;
    }

    public Boolean getAcceptanceRequired() {
        return this.acceptanceRequired;
    }

    public TermsType getTermsAndConditionsType() {
        return this.termsAndConditionsType;
    }

    public TermsState getTermsAndConditionsState() {
        return this.termsAndConditionsState;
    }

    public DateTime getModifiedAt() {
        return this.modifiedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MenigaTerms that = (MenigaTerms)o;
        if (this.creationDate != null ? !this.creationDate.equals((Object)that.creationDate) : that.creationDate != null) {
            return false;
        }
        if (this.content != null ? !this.content.equals(that.content) : that.content != null) {
            return false;
        }
        if (this.culture != null ? !this.culture.equals(that.culture) : that.culture != null) {
            return false;
        }
        if (this.acceptanceRequired != null ? !this.acceptanceRequired.equals(that.acceptanceRequired) : that.acceptanceRequired != null) {
            return false;
        }
        if (this.termsAndConditionsType != null ? !this.termsAndConditionsType.equals(that.termsAndConditionsType) : that.termsAndConditionsType != null) {
            return false;
        }
        if (this.termsAndConditionsState != that.termsAndConditionsState) {
            return false;
        }
        return this.modifiedAt != null ? this.modifiedAt.equals((Object)that.modifiedAt) : that.modifiedAt == null;
    }

    public int hashCode() {
        int result = this.creationDate != null ? this.creationDate.hashCode() : 0;
        result = 31 * result + (this.content != null ? this.content.hashCode() : 0);
        result = 31 * result + (this.culture != null ? this.culture.hashCode() : 0);
        result = 31 * result + (this.acceptanceRequired != null ? this.acceptanceRequired.hashCode() : 0);
        result = 31 * result + (this.termsAndConditionsType != null ? this.termsAndConditionsType.hashCode() : 0);
        result = 31 * result + (this.termsAndConditionsState != null ? this.termsAndConditionsState.hashCode() : 0);
        result = 31 * result + (this.modifiedAt != null ? this.modifiedAt.hashCode() : 0);
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeSerializable((Serializable)this.creationDate);
        dest.writeString(this.content);
        dest.writeString(this.culture);
        dest.writeValue((Object)this.acceptanceRequired);
        dest.writeParcelable((Parcelable)this.termsAndConditionsType, flags);
        dest.writeInt(this.termsAndConditionsState == null ? -1 : this.termsAndConditionsState.ordinal());
        dest.writeSerializable((Serializable)this.modifiedAt);
    }

    public MenigaTerms() {
    }

    protected MenigaTerms(Parcel in) {
        this.creationDate = (DateTime)in.readSerializable();
        this.content = in.readString();
        this.culture = in.readString();
        this.acceptanceRequired = (Boolean)in.readValue(Boolean.class.getClassLoader());
        this.termsAndConditionsType = (TermsType)in.readParcelable(TermsType.class.getClassLoader());
        int tmpTermsAndConditionsState = in.readInt();
        this.termsAndConditionsState = tmpTermsAndConditionsState == -1 ? null : TermsState.values()[tmpTermsAndConditionsState];
        this.modifiedAt = (DateTime)in.readSerializable();
    }

    public static void setOperator(MenigaTermsOperations operator) {
        apiOperator = operator;
    }

    public static Result<List<MenigaTerms>> fetch() {
        return apiOperator.getTerms(MenigaSDK.getMenigaSettings().getCulture());
    }

    public static Result<MenigaTerms> fetch(long typeId) {
        return apiOperator.getTerm(MenigaSDK.getMenigaSettings().getCulture(), typeId);
    }

    public static Result<List<MenigaTermType>> fetchTypes() {
        return apiOperator.getTermTypes(MenigaSDK.getMenigaSettings().getCulture());
    }

    public static Result<Void> accept(long typeId) {
        return apiOperator.acceptTerms(typeId);
    }

    public static Result<Void> decline(long typeId) {
        return apiOperator.declineTerms(typeId);
    }

    static {
        CREATOR = new Parcelable.Creator<MenigaTerms>(){

            public MenigaTerms createFromParcel(Parcel source) {
                return new MenigaTerms(source);
            }

            public MenigaTerms[] newArray(int size) {
                return new MenigaTerms[size];
            }
        };
    }
}

