/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.sync;

import android.os.Parcel;
import android.os.Parcelable;
import com.meniga.sdk.models.sync.AccountSyncStatus;
import com.meniga.sdk.models.sync.RealmSyncResult;
import com.meniga.sdk.models.user.AuthenticationChallenge;
import java.io.Serializable;
import java.util.List;
import org.joda.time.DateTime;

public class RealmSyncResponse
implements Serializable,
Parcelable {
    protected long realmCredentialsId;
    protected String realmCredentialsDisplayName;
    protected long organizationId;
    protected String organizationName;
    protected String organizationBankCode;
    protected List<AccountSyncStatus> accountSyncStatuses;
    protected AuthenticationChallenge authenticationChallenge;
    protected boolean isSyncDone;
    protected long realmId;
    protected DateTime realmSyncStartDate;
    protected DateTime realmSyncEndDate;
    protected RealmSyncResult status;
    public static final Parcelable.Creator<RealmSyncResponse> CREATOR = new Parcelable.Creator<RealmSyncResponse>(){

        public RealmSyncResponse createFromParcel(Parcel source) {
            return new RealmSyncResponse(source);
        }

        public RealmSyncResponse[] newArray(int size) {
            return new RealmSyncResponse[size];
        }
    };

    protected RealmSyncResponse() {
    }

    protected RealmSyncResponse(Parcel in) {
        this.realmCredentialsId = in.readLong();
        this.realmCredentialsDisplayName = in.readString();
        this.organizationId = in.readLong();
        this.organizationName = in.readString();
        this.organizationBankCode = in.readString();
        this.accountSyncStatuses = in.createTypedArrayList(AccountSyncStatus.CREATOR);
        this.authenticationChallenge = (AuthenticationChallenge)in.readParcelable(AuthenticationChallenge.class.getClassLoader());
        this.isSyncDone = in.readByte() != 0;
        this.realmId = in.readLong();
        this.realmSyncStartDate = (DateTime)in.readSerializable();
        this.realmSyncEndDate = (DateTime)in.readSerializable();
        int tmpStatus = in.readInt();
        this.status = tmpStatus == -1 ? null : RealmSyncResult.values()[tmpStatus];
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.realmCredentialsId);
        dest.writeString(this.realmCredentialsDisplayName);
        dest.writeLong(this.organizationId);
        dest.writeString(this.organizationName);
        dest.writeString(this.organizationBankCode);
        dest.writeTypedList(this.accountSyncStatuses);
        dest.writeParcelable((Parcelable)this.authenticationChallenge, flags);
        dest.writeByte(this.isSyncDone ? (byte)1 : 0);
        dest.writeLong(this.realmId);
        dest.writeSerializable((Serializable)this.realmSyncStartDate);
        dest.writeSerializable((Serializable)this.realmSyncEndDate);
        dest.writeInt(this.status == null ? -1 : this.status.ordinal());
    }

    public long getRealmCredentialsId() {
        return this.realmCredentialsId;
    }

    public String getRealmCredentialsDisplayName() {
        return this.realmCredentialsDisplayName;
    }

    public long getOrganizationId() {
        return this.organizationId;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public String getOrganizationBankCode() {
        return this.organizationBankCode;
    }

    public boolean isSyncDone() {
        return this.isSyncDone;
    }

    public List<AccountSyncStatus> getAccountSyncStatuses() {
        return this.accountSyncStatuses;
    }

    public AuthenticationChallenge getAuthenticationChallenge() {
        return this.authenticationChallenge;
    }

    public long getRealmId() {
        return this.realmId;
    }

    public DateTime getRealmSyncStartDate() {
        return this.realmSyncStartDate;
    }

    public DateTime getRealmSyncEndDate() {
        return this.realmSyncEndDate;
    }

    public RealmSyncResult getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RealmSyncResponse that = (RealmSyncResponse)o;
        if (this.realmCredentialsId != that.realmCredentialsId) {
            return false;
        }
        if (this.organizationId != that.organizationId) {
            return false;
        }
        if (this.isSyncDone != that.isSyncDone) {
            return false;
        }
        if (this.realmId != that.realmId) {
            return false;
        }
        if (this.realmCredentialsDisplayName != null ? !this.realmCredentialsDisplayName.equals(that.realmCredentialsDisplayName) : that.realmCredentialsDisplayName != null) {
            return false;
        }
        if (this.organizationName != null ? !this.organizationName.equals(that.organizationName) : that.organizationName != null) {
            return false;
        }
        if (this.organizationBankCode != null ? !this.organizationBankCode.equals(that.organizationBankCode) : that.organizationBankCode != null) {
            return false;
        }
        if (this.accountSyncStatuses != null ? !this.accountSyncStatuses.equals(that.accountSyncStatuses) : that.accountSyncStatuses != null) {
            return false;
        }
        if (this.authenticationChallenge != null ? !this.authenticationChallenge.equals(that.authenticationChallenge) : that.authenticationChallenge != null) {
            return false;
        }
        if (this.realmSyncStartDate != null ? !this.realmSyncStartDate.equals((Object)that.realmSyncStartDate) : that.realmSyncStartDate != null) {
            return false;
        }
        if (this.realmSyncEndDate != null ? !this.realmSyncEndDate.equals((Object)that.realmSyncEndDate) : that.realmSyncEndDate != null) {
            return false;
        }
        return this.status == that.status;
    }

    public int hashCode() {
        int result = (int)(this.realmCredentialsId ^ this.realmCredentialsId >>> 32);
        result = 31 * result + (this.realmCredentialsDisplayName != null ? this.realmCredentialsDisplayName.hashCode() : 0);
        result = 31 * result + (int)(this.organizationId ^ this.organizationId >>> 32);
        result = 31 * result + (this.organizationName != null ? this.organizationName.hashCode() : 0);
        result = 31 * result + (this.organizationBankCode != null ? this.organizationBankCode.hashCode() : 0);
        result = 31 * result + (this.accountSyncStatuses != null ? this.accountSyncStatuses.hashCode() : 0);
        result = 31 * result + (this.authenticationChallenge != null ? this.authenticationChallenge.hashCode() : 0);
        result = 31 * result + (this.isSyncDone ? 1 : 0);
        result = 31 * result + (int)(this.realmId ^ this.realmId >>> 32);
        result = 31 * result + (this.realmSyncStartDate != null ? this.realmSyncStartDate.hashCode() : 0);
        result = 31 * result + (this.realmSyncEndDate != null ? this.realmSyncEndDate.hashCode() : 0);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        return result;
    }
}

