/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.organizations;

import android.os.Parcel;
import android.os.Parcelable;
import com.meniga.sdk.models.accounts.enums.AccountCategory;
import com.meniga.sdk.webservices.requests.QueryRequestObject;
import java.io.Serializable;

public class MenigaRealmAccount
extends QueryRequestObject
implements Parcelable,
Serializable {
    protected String name;
    protected String accountIdentifier;
    protected long accountTypeId;
    protected boolean accountExists;
    public static final Parcelable.Creator<MenigaRealmAccount> CREATOR = new Parcelable.Creator<MenigaRealmAccount>(){

        public MenigaRealmAccount createFromParcel(Parcel source) {
            return new MenigaRealmAccount(source);
        }

        public MenigaRealmAccount[] newArray(int size) {
            return new MenigaRealmAccount[size];
        }
    };

    protected MenigaRealmAccount() {
    }

    protected MenigaRealmAccount(Parcel in) {
        this.name = in.readString();
        this.accountIdentifier = in.readString();
        this.accountTypeId = in.readLong();
        this.accountExists = in.readByte() != 0;
    }

    public String getName() {
        return this.name;
    }

    public String getAccountIdentifier() {
        return this.accountIdentifier;
    }

    @Deprecated
    public AccountCategory getAccountCategory() {
        return AccountCategory.fromId(this.accountTypeId);
    }

    public long getAccountTypeId() {
        return this.accountTypeId;
    }

    public boolean isAccountAlreadyConnected() {
        return this.accountExists;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MenigaRealmAccount that = (MenigaRealmAccount)o;
        if (this.accountTypeId != that.accountTypeId) {
            return false;
        }
        if (this.accountExists != that.accountExists) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return this.accountIdentifier != null ? this.accountIdentifier.equals(that.accountIdentifier) : that.accountIdentifier == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.accountIdentifier != null ? this.accountIdentifier.hashCode() : 0);
        result = 31 * result + (int)(this.accountTypeId ^ this.accountTypeId >>> 32);
        result = 31 * result + (this.accountExists ? 1 : 0);
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.name);
        dest.writeString(this.accountIdentifier);
        dest.writeLong(this.accountTypeId);
        dest.writeByte(this.accountExists ? (byte)1 : 0);
    }

    @Override
    public long getValueHash() {
        return (long)(this.name.hashCode() + this.accountIdentifier.hashCode()) + this.accountTypeId + (long)(this.accountExists ? 1 : 0);
    }
}

