/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.organizations;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;
import com.meniga.sdk.helpers.Result;
import com.meniga.sdk.models.organizations.MenigaRealm;
import com.meniga.sdk.models.organizations.operators.MenigaOrganizationOperations;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class MenigaOrganization
implements Serializable,
Parcelable {
    private static MenigaOrganizationOperations apiOperator;
    protected long id;
    protected String name;
    protected String altName;
    protected String identifier;
    protected int orderIndex;
    protected String iconFilename;
    protected long imageDataId;
    protected String imageData;
    protected List<MenigaRealm> realms;
    public static final Parcelable.Creator<MenigaOrganization> CREATOR;

    protected MenigaOrganization() {
    }

    protected MenigaOrganization(Parcel in) {
        this.id = in.readLong();
        this.name = in.readString();
        this.altName = in.readString();
        this.identifier = in.readString();
        this.orderIndex = in.readInt();
        this.iconFilename = in.readString();
        this.imageDataId = in.readLong();
        this.imageData = in.readString();
        this.realms = in.createTypedArrayList(MenigaRealm.CREATOR);
    }

    public static void setOperator(MenigaOrganizationOperations operator) {
        apiOperator = operator;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getAltName() {
        return this.altName;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public int getOrderIndex() {
        return this.orderIndex;
    }

    public String getIconFilename() {
        return this.iconFilename;
    }

    public long getImageDataId() {
        return this.imageDataId;
    }

    public Bitmap getImageData() throws UnsupportedEncodingException {
        if (this.imageData == null) {
            return null;
        }
        byte[] bytes = Base64.decode((String)this.imageData, (int)0);
        return BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
    }

    public List<MenigaRealm> getRealms() {
        return this.realms;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MenigaOrganization that = (MenigaOrganization)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.orderIndex != that.orderIndex) {
            return false;
        }
        if (this.imageDataId != that.imageDataId) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.altName != null ? !this.altName.equals(that.altName) : that.altName != null) {
            return false;
        }
        if (this.identifier != null ? !this.identifier.equals(that.identifier) : that.identifier != null) {
            return false;
        }
        if (this.iconFilename != null ? !this.iconFilename.equals(that.iconFilename) : that.iconFilename != null) {
            return false;
        }
        if (this.imageData != null ? !this.imageData.equals(that.imageData) : that.imageData != null) {
            return false;
        }
        return this.realms != null ? this.realms.equals(that.realms) : that.realms == null;
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.altName != null ? this.altName.hashCode() : 0);
        result = 31 * result + (this.identifier != null ? this.identifier.hashCode() : 0);
        result = 31 * result + this.orderIndex;
        result = 31 * result + (this.iconFilename != null ? this.iconFilename.hashCode() : 0);
        result = 31 * result + (int)(this.imageDataId ^ this.imageDataId >>> 32);
        result = 31 * result + (this.imageData != null ? this.imageData.hashCode() : 0);
        result = 31 * result + (this.realms != null ? this.realms.hashCode() : 0);
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.id);
        dest.writeString(this.name);
        dest.writeString(this.altName);
        dest.writeString(this.identifier);
        dest.writeInt(this.orderIndex);
        dest.writeString(this.iconFilename);
        dest.writeLong(this.imageDataId);
        dest.writeString(this.imageData);
        dest.writeTypedList(this.realms);
    }

    public static Result<List<MenigaOrganization>> fetch() {
        return apiOperator.getOrganizations();
    }

    static {
        CREATOR = new Parcelable.Creator<MenigaOrganization>(){

            public MenigaOrganization createFromParcel(Parcel source) {
                return new MenigaOrganization(source);
            }

            public MenigaOrganization[] newArray(int size) {
                return new MenigaOrganization[size];
            }
        };
    }
}

