/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.offers.reimbursementaccounts;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.Gson;
import com.meniga.sdk.helpers.GsonProvider;
import com.meniga.sdk.helpers.Result;
import com.meniga.sdk.models.offers.reimbursementaccounts.MenigaOfferAccountInfo;
import com.meniga.sdk.models.offers.reimbursementaccounts.MenigaReimbursementAccountPage;
import com.meniga.sdk.models.offers.reimbursementaccounts.MenigaReimbursementAccountType;
import com.meniga.sdk.models.offers.reimbursementaccounts.operators.MenigaReimbursementAccountOperations;
import java.io.Serializable;
import javax.annotation.Nonnull;

public class MenigaReimbursementAccount
implements Serializable,
Parcelable {
    protected static MenigaReimbursementAccountOperations apiOperator;
    protected long id;
    protected boolean isActive;
    protected boolean isVerified;
    protected String name;
    protected String accountType;
    protected String accountInfo;
    public static final Parcelable.Creator<MenigaReimbursementAccount> CREATOR;

    protected MenigaReimbursementAccount() {
    }

    protected MenigaReimbursementAccount(Parcel in) {
        this.id = in.readLong();
        this.isActive = in.readByte() != 0;
        this.isVerified = in.readByte() != 0;
        this.name = in.readString();
        this.accountType = in.readString();
        this.accountInfo = in.readString();
    }

    public static void setOperator(MenigaReimbursementAccountOperations apiOperator) {
        MenigaReimbursementAccount.apiOperator = apiOperator;
        MenigaReimbursementAccountType.setOperator(apiOperator);
    }

    public long getId() {
        return this.id;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isVerified() {
        return this.isVerified;
    }

    public <T extends MenigaOfferAccountInfo> T getAccountInfo(Class<T> type2) {
        Gson gson2 = GsonProvider.getGson();
        return (T)((MenigaOfferAccountInfo)gson2.fromJson(this.accountInfo, type2));
    }

    public void setAccountInfo(MenigaOfferAccountInfo accountInfo) {
        this.accountInfo = accountInfo.toJson();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAccountType() {
        return this.accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    @Nonnull
    public String getAccountInfo() {
        return this.accountInfo;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.id);
        dest.writeByte(this.isActive ? (byte)1 : 0);
        dest.writeByte(this.isVerified ? (byte)1 : 0);
        dest.writeString(this.name);
        dest.writeString(this.accountType);
        dest.writeString(this.accountInfo);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MenigaReimbursementAccount that = (MenigaReimbursementAccount)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.isActive != that.isActive) {
            return false;
        }
        if (this.isVerified != that.isVerified) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.accountType != null ? !this.accountType.equals(that.accountType) : that.accountType != null) {
            return false;
        }
        return this.accountInfo != null ? this.accountInfo.equals(that.accountInfo) : that.accountInfo == null;
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.isActive ? 1 : 0);
        result = 31 * result + (this.isVerified ? 1 : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.accountType != null ? this.accountType.hashCode() : 0);
        result = 31 * result + (this.accountInfo != null ? this.accountInfo.hashCode() : 0);
        return result;
    }

    public static Result<MenigaReimbursementAccount> fetch(int id) {
        return apiOperator.getReimbursementAccountById(id);
    }

    public static Result<MenigaReimbursementAccountPage> fetch() {
        return apiOperator.getReimbursementAccounts(false);
    }

    public static Result<MenigaReimbursementAccountPage> fetch(Boolean includeInactive) {
        return apiOperator.getReimbursementAccounts(includeInactive);
    }

    public static Result<MenigaReimbursementAccount> create(String name, String accountType, MenigaOfferAccountInfo accountInfo) {
        return apiOperator.createOfferAccount(name, accountType, accountInfo);
    }

    static {
        CREATOR = new Parcelable.Creator<MenigaReimbursementAccount>(){

            public MenigaReimbursementAccount createFromParcel(Parcel source) {
                return new MenigaReimbursementAccount(source);
            }

            public MenigaReimbursementAccount[] newArray(int size) {
                return new MenigaReimbursementAccount[size];
            }
        };
    }
}

