/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.offers.redemptions;

import android.os.Parcel;
import android.os.Parcelable;
import com.meniga.sdk.annotations.MetaProperty;
import com.meniga.sdk.helpers.MenigaDecimal;
import com.meniga.sdk.helpers.Result;
import com.meniga.sdk.models.offers.redemptions.MenigaRedemptionTransaction;
import com.meniga.sdk.models.offers.redemptions.MenigaScheduledReimbursement;
import com.meniga.sdk.models.offers.redemptions.operators.MenigaRedemptionsOperations;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;

public class MenigaRedemptions
extends ArrayList<MenigaRedemptionTransaction>
implements Parcelable,
Serializable {
    protected static MenigaRedemptionsOperations apiOperator;
    @MetaProperty
    protected MenigaDecimal redeemedAmount;
    @MetaProperty
    protected MenigaDecimal nextReimbursementAmount;
    @MetaProperty
    protected int activatedOffers;
    @MetaProperty
    protected MenigaDecimal spentAmount;
    @MetaProperty
    protected int totalCount;
    protected List<MenigaScheduledReimbursement> scheduledReimbursements = new ArrayList<MenigaScheduledReimbursement>();
    public static final Parcelable.Creator<MenigaRedemptions> CREATOR;

    protected MenigaRedemptions() {
    }

    public static void setOperator(MenigaRedemptionsOperations operator) {
        apiOperator = operator;
    }

    public static MenigaRedemptionsOperations getApiOperator() {
        return apiOperator;
    }

    public MenigaDecimal getRedeemedAmount() {
        return this.redeemedAmount;
    }

    public MenigaDecimal getNextReimbursementAmount() {
        return this.nextReimbursementAmount;
    }

    public int getActivatedOffers() {
        return this.activatedOffers;
    }

    public MenigaDecimal getSpentAmount() {
        return this.spentAmount;
    }

    public List<MenigaScheduledReimbursement> getScheduledReimbursements() {
        return this.scheduledReimbursements;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void setScheduledReimbursement(List<MenigaScheduledReimbursement> scheduled) {
        this.scheduledReimbursements = scheduled;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeSerializable((Serializable)this.redeemedAmount);
        dest.writeSerializable((Serializable)this.nextReimbursementAmount);
        dest.writeInt(this.activatedOffers);
        dest.writeSerializable((Serializable)this.spentAmount);
        dest.writeTypedList(this.scheduledReimbursements);
        dest.writeInt(this.totalCount);
        dest.writeList((List)this);
    }

    protected MenigaRedemptions(Parcel in) {
        this.redeemedAmount = (MenigaDecimal)in.readSerializable();
        this.nextReimbursementAmount = (MenigaDecimal)in.readSerializable();
        this.activatedOffers = in.readInt();
        this.spentAmount = (MenigaDecimal)in.readSerializable();
        this.scheduledReimbursements = in.createTypedArrayList(MenigaScheduledReimbursement.CREATOR);
        this.totalCount = in.readInt();
        in.readList((List)this, this.getClass().getClassLoader());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MenigaRedemptions that = (MenigaRedemptions)o;
        if (this.activatedOffers != that.activatedOffers) {
            return false;
        }
        if (this.totalCount != that.totalCount) {
            return false;
        }
        if (this.redeemedAmount != null ? !this.redeemedAmount.equals(that.redeemedAmount) : that.redeemedAmount != null) {
            return false;
        }
        if (this.nextReimbursementAmount != null ? !this.nextReimbursementAmount.equals(that.nextReimbursementAmount) : that.nextReimbursementAmount != null) {
            return false;
        }
        if (this.spentAmount != null ? !this.spentAmount.equals(that.spentAmount) : that.spentAmount != null) {
            return false;
        }
        return this.scheduledReimbursements != null ? this.scheduledReimbursements.equals(that.scheduledReimbursements) : that.scheduledReimbursements == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.redeemedAmount != null ? this.redeemedAmount.hashCode() : 0);
        result = 31 * result + (this.nextReimbursementAmount != null ? this.nextReimbursementAmount.hashCode() : 0);
        result = 31 * result + this.activatedOffers;
        result = 31 * result + (this.spentAmount != null ? this.spentAmount.hashCode() : 0);
        result = 31 * result + (this.scheduledReimbursements != null ? this.scheduledReimbursements.hashCode() : 0);
        result = 31 * result + this.totalCount;
        return result;
    }

    public static Result<MenigaRedemptions> fetch() {
        return apiOperator.getRedemptions(0, 1000, null, null);
    }

    public static Result<MenigaRedemptions> fetch(Integer skip, Integer take, DateTime dateFrom, DateTime dateTo) {
        return apiOperator.getRedemptions(skip, take, dateFrom, dateTo);
    }

    public static Result<MenigaRedemptions> fetch(DateTime dateFrom, DateTime dateTo) {
        return apiOperator.getRedemptions(0, 1000, dateFrom, dateTo);
    }

    static {
        CREATOR = new Parcelable.Creator<MenigaRedemptions>(){

            public MenigaRedemptions createFromParcel(Parcel source) {
                return new MenigaRedemptions(source);
            }

            public MenigaRedemptions[] newArray(int size) {
                return new MenigaRedemptions[size];
            }
        };
    }
}

