/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.offers;

import android.os.Parcel;
import android.os.Parcelable;
import com.meniga.sdk.annotations.MetaProperty;
import com.meniga.sdk.models.offers.MenigaOffer;
import com.meniga.sdk.models.offers.enums.OfferFilterState;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;

public class MenigaOfferPage
extends ArrayList<MenigaOffer>
implements Serializable,
Parcelable {
    protected int skip;
    protected int take;
    protected List<OfferFilterState> states = new ArrayList<OfferFilterState>();
    protected List<Long> offerIds = new ArrayList<Long>();
    protected boolean expiredWithRedemptionOnly = false;
    protected boolean hasMorePages = true;
    @MetaProperty
    private int availableOffers;
    @MetaProperty
    private int availableOffersActivated;
    @MetaProperty
    private int availableOffersDeclined;
    @MetaProperty
    private int offersActivated;
    @MetaProperty
    private int offersDeclined;
    @MetaProperty
    private int offersNotSeen;
    @MetaProperty
    private boolean offersEnabled;
    @MetaProperty
    private DateTime offersEnabledTimestamp;
    @MetaProperty
    private boolean termsAndConditionsAccepted;
    @MetaProperty
    private boolean isReimbursementAccountValid;
    @MetaProperty
    private int totalCount;
    public static final Parcelable.Creator<MenigaOfferPage> CREATOR = new Parcelable.Creator<MenigaOfferPage>(){

        public MenigaOfferPage createFromParcel(Parcel source) {
            return new MenigaOfferPage(source);
        }

        public MenigaOfferPage[] newArray(int size) {
            return new MenigaOfferPage[size];
        }
    };

    public MenigaOfferPage() {
    }

    protected MenigaOfferPage(Parcel in) {
        Parcelable[] offersRaw;
        this.skip = in.readInt();
        this.take = in.readInt();
        this.states = new ArrayList<OfferFilterState>();
        in.readList(this.states, OfferFilterState.class.getClassLoader());
        this.offerIds = new ArrayList<Long>();
        in.readList(this.offerIds, Integer.class.getClassLoader());
        this.expiredWithRedemptionOnly = in.readByte() != 0;
        this.hasMorePages = in.readByte() != 0;
        this.availableOffers = in.readInt();
        this.availableOffersActivated = in.readInt();
        this.availableOffersDeclined = in.readInt();
        this.offersActivated = in.readInt();
        this.offersDeclined = in.readInt();
        this.offersNotSeen = in.readInt();
        this.offersEnabled = in.readByte() != 0;
        this.offersEnabledTimestamp = (DateTime)in.readSerializable();
        this.termsAndConditionsAccepted = in.readByte() != 0;
        this.isReimbursementAccountValid = in.readByte() != 0;
        this.totalCount = in.readInt();
        for (Parcelable parcel : offersRaw = in.readParcelableArray(MenigaOffer.class.getClassLoader())) {
            this.add((MenigaOffer)parcel);
        }
    }

    public static MenigaOfferPage newInstance() {
        return new MenigaOfferPage();
    }

    public int getSkip() {
        return this.skip;
    }

    public int getTake() {
        return this.take;
    }

    public List<OfferFilterState> getStates() {
        return this.states;
    }

    public List<Long> getOfferIds() {
        return this.offerIds;
    }

    public boolean isExpiredWithRedemptionOnly() {
        return this.expiredWithRedemptionOnly;
    }

    public boolean hasMorePages() {
        return this.hasMorePages;
    }

    public int getAvailableOffers() {
        return this.availableOffers;
    }

    public boolean isTermsAndConditionsAccepted() {
        return this.termsAndConditionsAccepted;
    }

    public int getAvailableOffersActivated() {
        return this.availableOffersActivated;
    }

    public int getAvailableOffersDeclined() {
        return this.availableOffersDeclined;
    }

    public int getOffersActivated() {
        return this.offersActivated;
    }

    public int getOffersDeclined() {
        return this.offersDeclined;
    }

    public int getOffersNotSeen() {
        return this.offersNotSeen;
    }

    public boolean isOffersEnabled() {
        return this.offersEnabled;
    }

    public DateTime getOffersEnabledTimestamp() {
        return this.offersEnabledTimestamp;
    }

    public boolean isReimbursementAccountValid() {
        return this.isReimbursementAccountValid;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MenigaOfferPage that = (MenigaOfferPage)o;
        if (this.skip != that.skip) {
            return false;
        }
        if (this.take != that.take) {
            return false;
        }
        if (this.expiredWithRedemptionOnly != that.expiredWithRedemptionOnly) {
            return false;
        }
        if (this.hasMorePages != that.hasMorePages) {
            return false;
        }
        if (this.availableOffers != that.availableOffers) {
            return false;
        }
        if (this.availableOffersActivated != that.availableOffersActivated) {
            return false;
        }
        if (this.availableOffersDeclined != that.availableOffersDeclined) {
            return false;
        }
        if (this.offersActivated != that.offersActivated) {
            return false;
        }
        if (this.offersDeclined != that.offersDeclined) {
            return false;
        }
        if (this.offersNotSeen != that.offersNotSeen) {
            return false;
        }
        if (this.offersEnabled != that.offersEnabled) {
            return false;
        }
        if (this.termsAndConditionsAccepted != that.termsAndConditionsAccepted) {
            return false;
        }
        if (this.isReimbursementAccountValid != that.isReimbursementAccountValid) {
            return false;
        }
        if (this.totalCount != that.totalCount) {
            return false;
        }
        if (this.states != null ? !this.states.equals(that.states) : that.states != null) {
            return false;
        }
        if (this.offerIds != null ? !this.offerIds.equals(that.offerIds) : that.offerIds != null) {
            return false;
        }
        return this.offersEnabledTimestamp != null ? this.offersEnabledTimestamp.equals((Object)that.offersEnabledTimestamp) : that.offersEnabledTimestamp == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.skip;
        result = 31 * result + this.take;
        result = 31 * result + (this.states != null ? this.states.hashCode() : 0);
        result = 31 * result + (this.offerIds != null ? this.offerIds.hashCode() : 0);
        result = 31 * result + (this.expiredWithRedemptionOnly ? 1 : 0);
        result = 31 * result + (this.hasMorePages ? 1 : 0);
        result = 31 * result + this.availableOffers;
        result = 31 * result + this.availableOffersActivated;
        result = 31 * result + this.availableOffersDeclined;
        result = 31 * result + this.offersActivated;
        result = 31 * result + this.offersDeclined;
        result = 31 * result + this.offersNotSeen;
        result = 31 * result + (this.offersEnabled ? 1 : 0);
        result = 31 * result + (this.offersEnabledTimestamp != null ? this.offersEnabledTimestamp.hashCode() : 0);
        result = 31 * result + (this.termsAndConditionsAccepted ? 1 : 0);
        result = 31 * result + (this.isReimbursementAccountValid ? 1 : 0);
        result = 31 * result + this.totalCount;
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.skip);
        dest.writeInt(this.take);
        dest.writeList(this.states);
        dest.writeList(this.offerIds);
        dest.writeByte(this.expiredWithRedemptionOnly ? (byte)1 : 0);
        dest.writeByte(this.hasMorePages ? (byte)1 : 0);
        dest.writeInt(this.availableOffers);
        dest.writeInt(this.availableOffersActivated);
        dest.writeInt(this.availableOffersDeclined);
        dest.writeInt(this.offersActivated);
        dest.writeInt(this.offersDeclined);
        dest.writeInt(this.offersNotSeen);
        dest.writeByte(this.offersEnabled ? (byte)1 : 0);
        dest.writeSerializable((Serializable)this.offersEnabledTimestamp);
        dest.writeByte(this.termsAndConditionsAccepted ? (byte)1 : 0);
        dest.writeByte(this.isReimbursementAccountValid ? (byte)1 : 0);
        dest.writeInt(this.totalCount);
        Parcelable[] arr = new MenigaOffer[this.size()];
        this.toArray(arr);
        dest.writeParcelableArray(arr, 0);
    }
}

