/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.networth;

import android.os.Parcel;
import android.os.Parcelable;
import com.meniga.sdk.MenigaSDK;
import com.meniga.sdk.helpers.Interceptor;
import com.meniga.sdk.helpers.KeyVal;
import com.meniga.sdk.helpers.MenigaDecimal;
import com.meniga.sdk.helpers.Result;
import com.meniga.sdk.models.Merge;
import com.meniga.sdk.models.networth.MenigaNetWorthAccountType;
import com.meniga.sdk.models.networth.MenigaNetWorthBalance;
import com.meniga.sdk.models.networth.enums.NetWorthType;
import com.meniga.sdk.models.networth.operators.MenigaNetWorthOperations;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;

public class MenigaNetWorth
implements Serializable,
Parcelable,
Cloneable {
    public static final Parcelable.Creator<MenigaNetWorth> CREATOR = new Parcelable.Creator<MenigaNetWorth>(){

        public MenigaNetWorth createFromParcel(Parcel source) {
            return new MenigaNetWorth(source);
        }

        public MenigaNetWorth[] newArray(int size) {
            return new MenigaNetWorth[size];
        }
    };
    protected static MenigaNetWorthOperations apiOperator;
    protected long accountId;
    protected Long realmAccountTypeId;
    protected String accountName;
    protected Boolean isImport;
    protected Boolean isManual;
    protected Boolean isExcluded;
    protected NetWorthType netWorthType;
    protected MenigaDecimal currentBalance;
    protected List<MenigaNetWorthBalance> history = new ArrayList<MenigaNetWorthBalance>();
    protected MenigaNetWorthAccountType accountType;

    protected MenigaNetWorth() {
    }

    protected MenigaNetWorth(Parcel in) {
        boolean currBalaIsNull;
        int tmpNetWorthType;
        int tmpisExcluded;
        int tmpisManual;
        this.accountId = in.readLong();
        long tmprealmAccountTypeId = in.readLong();
        if (tmprealmAccountTypeId > -1L) {
            this.realmAccountTypeId = tmprealmAccountTypeId;
        }
        this.accountName = in.readString();
        int tmpisImport = in.readInt();
        if (tmpisImport > -1) {
            this.isImport = tmpisImport == 1;
        }
        if ((tmpisManual = in.readInt()) > -1) {
            this.isManual = tmpisManual == 1;
        }
        if ((tmpisExcluded = in.readInt()) > -1) {
            this.isExcluded = tmpisExcluded == 1;
        }
        this.netWorthType = (tmpNetWorthType = in.readInt()) == -1 ? null : NetWorthType.values()[tmpNetWorthType];
        boolean bl = currBalaIsNull = in.readByte() == 1;
        if (!currBalaIsNull) {
            this.currentBalance = new MenigaDecimal(in.readDouble());
        }
        this.accountType = (MenigaNetWorthAccountType)in.readParcelable(MenigaNetWorthAccountType.class.getClassLoader());
        this.history = new ArrayList<MenigaNetWorthBalance>();
        Parcelable[] arr = in.readParcelableArray(MenigaNetWorthBalance.class.getClassLoader());
        for (int i = 0; i < arr.length; ++i) {
            this.history.add((MenigaNetWorthBalance)arr[i]);
        }
    }

    public static void setOperator(MenigaNetWorthOperations operator) {
        apiOperator = operator;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.accountId);
        dest.writeLong(this.realmAccountTypeId == null ? -1L : this.realmAccountTypeId);
        dest.writeString(this.accountName);
        dest.writeInt(this.isImport == null ? -1 : (this.isImport != false ? 1 : 0));
        dest.writeInt(this.isManual == null ? -1 : (this.isManual != false ? 1 : 0));
        dest.writeInt(this.isExcluded == null ? -1 : (this.isExcluded != false ? 1 : 0));
        dest.writeInt(this.netWorthType == null ? -1 : this.netWorthType.ordinal());
        dest.writeByte(this.currentBalance == null ? (byte)1 : 0);
        if (this.currentBalance != null) {
            dest.writeDouble(this.currentBalance.doubleValue());
        }
        dest.writeParcelable((Parcelable)this.accountType, flags);
        Parcelable[] arr = new Parcelable[this.history.size()];
        for (int i = 0; i < this.history.size(); ++i) {
            arr[i] = this.history.get(i);
        }
        dest.writeParcelableArray(arr, flags);
    }

    public MenigaNetWorth clone() throws CloneNotSupportedException {
        return (MenigaNetWorth)super.clone();
    }

    public int describeContents() {
        return 0;
    }

    public long getId() {
        return this.accountId;
    }

    public String getName() {
        return this.accountName;
    }

    public void setName(String name) {
        this.accountName = name;
    }

    public Long getRealmAccountTypeId() {
        return this.realmAccountTypeId;
    }

    public Boolean getIsImport() {
        return this.isImport;
    }

    public Boolean getIsManual() {
        if (this.isManual == null) {
            return false;
        }
        return this.isManual;
    }

    public boolean getIsExcluded() {
        if (this.isExcluded == null) {
            return false;
        }
        return this.isExcluded;
    }

    public void setIsExcluded(Boolean isExcluded) {
        this.isExcluded = isExcluded;
    }

    public NetWorthType getNetWorthType() {
        return this.netWorthType;
    }

    public MenigaDecimal getCurrentBalance() {
        return this.currentBalance;
    }

    public void setCurrentBalance(MenigaDecimal currentBalance) {
        this.currentBalance = currentBalance;
    }

    public MenigaNetWorthAccountType getAccountType() {
        return this.accountType;
    }

    public List<MenigaNetWorthBalance> getHistory() {
        return this.history;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MenigaNetWorth that = (MenigaNetWorth)o;
        if (this.accountId != that.accountId) {
            return false;
        }
        if (this.realmAccountTypeId != null ? !this.realmAccountTypeId.equals(that.realmAccountTypeId) : that.realmAccountTypeId != null) {
            return false;
        }
        if (this.accountName != null ? !this.accountName.equals(that.accountName) : that.accountName != null) {
            return false;
        }
        if (this.isImport != null ? !this.isImport.equals(that.isImport) : that.isImport != null) {
            return false;
        }
        if (this.isManual != null ? !this.isManual.equals(that.isManual) : that.isManual != null) {
            return false;
        }
        if (this.isExcluded != null ? !this.isExcluded.equals(that.isExcluded) : that.isExcluded != null) {
            return false;
        }
        if (this.netWorthType != that.netWorthType) {
            return false;
        }
        if (this.currentBalance != null ? !this.currentBalance.equals(that.currentBalance) : that.currentBalance != null) {
            return false;
        }
        if (this.history != null ? !this.history.equals(that.history) : that.history != null) {
            return false;
        }
        return this.accountType != null ? this.accountType.equals(that.accountType) : that.accountType == null;
    }

    public int hashCode() {
        int result = (int)(this.accountId ^ this.accountId >>> 32);
        result = 31 * result + (this.realmAccountTypeId != null ? this.realmAccountTypeId.hashCode() : 0);
        result = 31 * result + (this.accountName != null ? this.accountName.hashCode() : 0);
        result = 31 * result + (this.isImport != null ? this.isImport.hashCode() : 0);
        result = 31 * result + (this.isManual != null ? this.isManual.hashCode() : 0);
        result = 31 * result + (this.isExcluded != null ? this.isExcluded.hashCode() : 0);
        result = 31 * result + (this.netWorthType != null ? this.netWorthType.hashCode() : 0);
        result = 31 * result + (this.currentBalance != null ? this.currentBalance.hashCode() : 0);
        result = 31 * result + (this.history != null ? this.history.hashCode() : 0);
        result = 31 * result + (this.accountType != null ? this.accountType.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.accountName;
    }

    public Result<Void> delete() {
        return apiOperator.deleteNetWorthAccount(this.accountId);
    }

    public Result<Void> update() {
        return apiOperator.updateNetWorthAccount(this.accountId, this.isExcluded, this.accountName);
    }

    public Result<List<MenigaNetWorth>> refresh() {
        Result<List<MenigaNetWorth>> task2 = MenigaNetWorth.fetch(DateTime.now().minusYears(100), DateTime.now(), 0, -1);
        return MenigaSDK.getMenigaSettings().getTaskAdapter().intercept(task2, new Interceptor<List<MenigaNetWorth>>(){

            @Override
            public void onFinished(List<MenigaNetWorth> result, boolean failed) {
                if (!failed) {
                    for (MenigaNetWorth netWorth : result) {
                        if (netWorth.getId() != MenigaNetWorth.this.getId()) continue;
                        try {
                            Merge.merge(MenigaNetWorth.this, netWorth);
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                }
            }
        });
    }

    public static Result<MenigaNetWorth> fetch(long id) {
        return apiOperator.getNetWorth(id);
    }

    public static Result<List<MenigaNetWorth>> fetch(DateTime startDate, DateTime endDate, int skip, int take) {
        return apiOperator.getNetWorth(startDate, endDate, false, skip, take);
    }

    public static Result<List<MenigaNetWorth>> fetchSummary(DateTime startDate, DateTime endDate, int skip, int take) {
        return apiOperator.getNetWorth(startDate, endDate, true, skip, take);
    }

    public static Result<MenigaNetWorth> create(MenigaDecimal initialBalance, MenigaDecimal currentBalance, String accountIdentifier, String name, NetWorthType networthType, DateTime initialBalanceDate) {
        return apiOperator.createNetWorthAccount(initialBalance, currentBalance, accountIdentifier, name, networthType.toString(), initialBalanceDate);
    }

    public static Result<MenigaNetWorthBalance> fetchFirstBalanceEntry(boolean excludeAccountsExcludedFromNetWorth) {
        return apiOperator.fetchFirstBalanceEntry(excludeAccountsExcludedFromNetWorth);
    }

    public static Result<List<KeyVal<Long, String>>> fetchNetWorthTypes() {
        return apiOperator.getNetWorthTypes();
    }
}

