/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.merchants;

import android.os.Parcel;
import android.os.Parcelable;
import com.meniga.sdk.helpers.MenigaDecimal;
import com.meniga.sdk.helpers.Result;
import com.meniga.sdk.models.merchants.TopMerchantOptions;
import com.meniga.sdk.models.merchants.operators.MenigaTopMerchantOperations;
import com.meniga.sdk.models.transactions.TransactionsFilter;
import java.io.Serializable;
import java.util.List;

public class MenigaTopMerchant
implements Parcelable,
Serializable {
    protected long merchantId;
    protected String text;
    protected MenigaDecimal nettoAmount;
    protected int transactionCount;
    protected static MenigaTopMerchantOperations apiOperations;
    public static final Parcelable.Creator<MenigaTopMerchant> CREATOR;

    protected MenigaTopMerchant() {
    }

    protected MenigaTopMerchant(Parcel in) {
        this.merchantId = in.readLong();
        this.text = in.readString();
        this.nettoAmount = (MenigaDecimal)in.readSerializable();
        this.transactionCount = in.readInt();
    }

    public static void setOperator(MenigaTopMerchantOperations operator) {
        apiOperations = operator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MenigaTopMerchant that = (MenigaTopMerchant)o;
        if (this.merchantId != that.merchantId) {
            return false;
        }
        if (this.transactionCount != that.transactionCount) {
            return false;
        }
        if (this.text != null ? !this.text.equals(that.text) : that.text != null) {
            return false;
        }
        return this.nettoAmount != null ? this.nettoAmount.equals(that.nettoAmount) : that.nettoAmount == null;
    }

    public int hashCode() {
        int result = (int)(this.merchantId ^ this.merchantId >>> 32);
        result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
        result = 31 * result + (this.nettoAmount != null ? this.nettoAmount.hashCode() : 0);
        result = 31 * result + this.transactionCount;
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.merchantId);
        dest.writeString(this.text);
        dest.writeSerializable((Serializable)this.nettoAmount);
        dest.writeInt(this.transactionCount);
    }

    public long getMerchantId() {
        return this.merchantId;
    }

    public String getText() {
        return this.text;
    }

    public MenigaDecimal getNettoAmount() {
        return this.nettoAmount;
    }

    public int getTransactionCount() {
        return this.transactionCount;
    }

    public static Result<List<MenigaTopMerchant>> fetch(TransactionsFilter filter, TopMerchantOptions options) {
        return apiOperations.getTopMerchants(filter, options);
    }

    static {
        CREATOR = new Parcelable.Creator<MenigaTopMerchant>(){

            public MenigaTopMerchant createFromParcel(Parcel source) {
                return new MenigaTopMerchant(source);
            }

            public MenigaTopMerchant[] newArray(int size) {
                return new MenigaTopMerchant[size];
            }
        };
    }
}

