/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.feed;

import android.os.Parcel;
import android.os.Parcelable;
import com.meniga.sdk.helpers.MenigaDecimal;
import com.meniga.sdk.models.feed.MenigaFeedItem;
import com.meniga.sdk.models.offers.RelevanceHook;
import com.meniga.sdk.models.offers.enums.OfferState;
import com.meniga.sdk.models.offers.enums.RewardType;
import java.io.Serializable;
import org.joda.time.DateTime;

public class MenigaOfferEvent
implements MenigaFeedItem,
Serializable,
Cloneable,
Parcelable {
    protected String validationToken;
    protected MenigaDecimal reward;
    protected RelevanceHook relevanceHook;
    protected OfferState state;
    protected int daysLeft;
    protected String merchantName;
    protected MenigaDecimal minimumPurchaseAmount;
    protected MenigaDecimal maximumCashbackPerPurchase;
    protected DateTime date;
    protected long topicId;
    protected String title;
    protected String body;
    protected String typeName;
    protected RewardType rewardType;
    protected String eventTypeIdentifier;
    protected String topicName;
    public static final Parcelable.Creator<MenigaOfferEvent> CREATOR = new Parcelable.Creator<MenigaOfferEvent>(){

        public MenigaOfferEvent createFromParcel(Parcel source) {
            return new MenigaOfferEvent(source);
        }

        public MenigaOfferEvent[] newArray(int size) {
            return new MenigaOfferEvent[size];
        }
    };

    protected MenigaOfferEvent() {
    }

    protected MenigaOfferEvent(Parcel in) {
        this.validationToken = in.readString();
        this.reward = (MenigaDecimal)in.readSerializable();
        this.relevanceHook = (RelevanceHook)in.readParcelable(RelevanceHook.class.getClassLoader());
        int tmpState = in.readInt();
        this.state = tmpState == -1 ? null : OfferState.values()[tmpState];
        this.daysLeft = in.readInt();
        this.merchantName = in.readString();
        this.minimumPurchaseAmount = (MenigaDecimal)in.readSerializable();
        this.maximumCashbackPerPurchase = (MenigaDecimal)in.readSerializable();
        this.date = (DateTime)in.readSerializable();
        this.topicId = in.readLong();
        this.topicName = in.readString();
        this.title = in.readString();
        this.body = in.readString();
        this.typeName = in.readString();
        int tmpRewardType = in.readInt();
        this.rewardType = tmpRewardType == -1 ? null : RewardType.values()[tmpRewardType];
    }

    public String getValidationToken() {
        return this.validationToken;
    }

    public MenigaDecimal getReward() {
        return this.reward;
    }

    public RelevanceHook getRelevanceHook() {
        return this.relevanceHook;
    }

    public OfferState getState() {
        return this.state;
    }

    public int getDaysLeft() {
        return this.daysLeft;
    }

    public String getMerchantName() {
        return this.merchantName;
    }

    public MenigaDecimal getMinimumPurchaseAmount() {
        return this.minimumPurchaseAmount;
    }

    public MenigaDecimal getMaximumCashbackPerPurchase() {
        return this.maximumCashbackPerPurchase;
    }

    @Override
    public MenigaOfferEvent clone() throws CloneNotSupportedException {
        return (MenigaOfferEvent)super.clone();
    }

    @Override
    public DateTime getDate() {
        return this.date;
    }

    @Override
    public String getEventTypeIdentifier() {
        return this.eventTypeIdentifier;
    }

    public long getTopicId() {
        return this.topicId;
    }

    @Override
    public String getTopicName() {
        return this.topicName;
    }

    public String getTitle() {
        return this.title;
    }

    public String getBody() {
        return this.body;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public RewardType getRewardType() {
        return this.rewardType;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.validationToken);
        dest.writeSerializable((Serializable)this.reward);
        dest.writeParcelable((Parcelable)this.relevanceHook, flags);
        dest.writeInt(this.state == null ? -1 : this.state.ordinal());
        dest.writeInt(this.daysLeft);
        dest.writeString(this.merchantName);
        dest.writeSerializable((Serializable)this.minimumPurchaseAmount);
        dest.writeSerializable((Serializable)this.maximumCashbackPerPurchase);
        dest.writeSerializable((Serializable)this.date);
        dest.writeLong(this.topicId);
        dest.writeString(this.topicName);
        dest.writeString(this.title);
        dest.writeString(this.body);
        dest.writeString(this.typeName);
        dest.writeInt(this.rewardType == null ? -1 : this.rewardType.ordinal());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MenigaOfferEvent that = (MenigaOfferEvent)o;
        if (this.daysLeft != that.daysLeft) {
            return false;
        }
        if (this.topicId != that.topicId) {
            return false;
        }
        if (this.validationToken != null ? !this.validationToken.equals(that.validationToken) : that.validationToken != null) {
            return false;
        }
        if (this.reward != null ? !this.reward.equals(that.reward) : that.reward != null) {
            return false;
        }
        if (this.relevanceHook != null ? !this.relevanceHook.equals(that.relevanceHook) : that.relevanceHook != null) {
            return false;
        }
        if (this.state != that.state) {
            return false;
        }
        if (this.merchantName != null ? !this.merchantName.equals(that.merchantName) : that.merchantName != null) {
            return false;
        }
        if (this.minimumPurchaseAmount != null ? !this.minimumPurchaseAmount.equals(that.minimumPurchaseAmount) : that.minimumPurchaseAmount != null) {
            return false;
        }
        if (this.maximumCashbackPerPurchase != null ? !this.maximumCashbackPerPurchase.equals(that.maximumCashbackPerPurchase) : that.maximumCashbackPerPurchase != null) {
            return false;
        }
        if (this.date != null ? !this.date.equals((Object)that.date) : that.date != null) {
            return false;
        }
        if (this.topicName != null ? !this.topicName.equals(that.topicName) : that.topicName != null) {
            return false;
        }
        if (this.title != null ? !this.title.equals(that.title) : that.title != null) {
            return false;
        }
        if (this.body != null ? !this.body.equals(that.body) : that.body != null) {
            return false;
        }
        if (this.typeName != null ? !this.typeName.equals(that.typeName) : that.typeName != null) {
            return false;
        }
        return this.rewardType == that.rewardType;
    }

    public int hashCode() {
        int result = this.validationToken != null ? this.validationToken.hashCode() : 0;
        result = 31 * result + (this.reward != null ? this.reward.hashCode() : 0);
        result = 31 * result + (this.relevanceHook != null ? this.relevanceHook.hashCode() : 0);
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + this.daysLeft;
        result = 31 * result + (this.merchantName != null ? this.merchantName.hashCode() : 0);
        result = 31 * result + (this.minimumPurchaseAmount != null ? this.minimumPurchaseAmount.hashCode() : 0);
        result = 31 * result + (this.maximumCashbackPerPurchase != null ? this.maximumCashbackPerPurchase.hashCode() : 0);
        result = 31 * result + (this.date != null ? this.date.hashCode() : 0);
        result = 31 * result + (int)(this.topicId ^ this.topicId >>> 32);
        result = 31 * result + (this.topicName != null ? this.topicName.hashCode() : 0);
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
        result = 31 * result + (this.typeName != null ? this.typeName.hashCode() : 0);
        result = 31 * result + (this.rewardType != null ? this.rewardType.hashCode() : 0);
        return result;
    }
}

