/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.feed;

import android.os.Parcel;
import android.os.Parcelable;
import com.meniga.sdk.MenigaSDK;
import com.meniga.sdk.helpers.Interceptor;
import com.meniga.sdk.helpers.PaginationUtils;
import com.meniga.sdk.helpers.Result;
import com.meniga.sdk.models.feed.FeedFilter;
import com.meniga.sdk.models.feed.MenigaFeedItem;
import com.meniga.sdk.models.feed.MenigaScheduledEvent;
import com.meniga.sdk.models.feed.operators.MenigaFeedOperations;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.joda.time.DateTime;

public class MenigaFeed
extends ArrayList<MenigaFeedItem>
implements Parcelable,
Serializable,
Cloneable {
    public static final Parcelable.Creator<MenigaFeed> CREATOR = new Parcelable.Creator<MenigaFeed>(){

        public MenigaFeed createFromParcel(Parcel source) {
            return new MenigaFeed(source);
        }

        public MenigaFeed[] newArray(int size) {
            return new MenigaFeed[size];
        }
    };
    protected static MenigaFeedOperations apiOperator;
    protected boolean hasMoreData = true;
    protected Integer totalCount;
    protected DateTime actualEndDate;
    protected DateTime from;
    protected DateTime to;
    protected int page;
    protected int itemsPerPage;

    public MenigaFeed() {
    }

    protected MenigaFeed(Parcel in) {
        this.hasMoreData = in.readByte() != 0;
        this.totalCount = (Integer)in.readValue(Integer.class.getClassLoader());
        long actual = in.readLong();
        this.actualEndDate = actual == 0L ? null : new DateTime(actual);
        long fromLong = in.readLong();
        this.from = fromLong == 0L ? null : new DateTime(fromLong);
        long toLong = in.readLong();
        this.to = toLong == 0L ? null : new DateTime(toLong);
        this.page = in.readInt();
        this.itemsPerPage = in.readInt();
        this.addAll(in.readArrayList(this.getClass().getClassLoader()));
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByte(this.hasMoreData ? (byte)1 : 0);
        dest.writeValue((Object)this.totalCount);
        dest.writeLong(this.actualEndDate != null ? this.actualEndDate.getMillis() : 0L);
        dest.writeLong(this.from != null ? this.from.getMillis() : 0L);
        dest.writeLong(this.to != null ? this.to.getMillis() : 0L);
        dest.writeInt(this.page);
        dest.writeInt(this.itemsPerPage);
        dest.writeList((List)this);
    }

    public static void setOperator(MenigaFeedOperations operator) {
        apiOperator = operator;
    }

    private void setActualEndDate(DateTime actualEndDate) {
        this.actualEndDate = actualEndDate;
    }

    public DateTime getFrom() {
        return this.from;
    }

    public DateTime getTo() {
        return this.to;
    }

    public int getPage() {
        return this.page;
    }

    public int getItemsPerPage() {
        return this.itemsPerPage;
    }

    public DateTime getActualEndDate() {
        return this.actualEndDate;
    }

    @Override
    public MenigaFeed clone() {
        return (MenigaFeed)super.clone();
    }

    public int describeContents() {
        return 0;
    }

    public boolean hasMoreData() {
        return this.hasMoreData;
    }

    public boolean hasMorePages() {
        return this.totalCount != null && PaginationUtils.hasMoreData(this.totalCount, this.page, this.itemsPerPage);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MenigaFeed that = (MenigaFeed)o;
        if (this.page != that.page) {
            return false;
        }
        if (this.itemsPerPage != that.itemsPerPage) {
            return false;
        }
        if (this.totalCount != null ? !this.totalCount.equals(that.totalCount) : that.totalCount != null) {
            return false;
        }
        if (this.actualEndDate != null ? !this.actualEndDate.equals((Object)that.actualEndDate) : that.actualEndDate != null) {
            return false;
        }
        if (this.from != null ? !this.from.equals((Object)that.from) : that.from != null) {
            return false;
        }
        return this.to != null ? this.to.equals((Object)that.to) : that.to == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.totalCount != null ? this.totalCount.hashCode() : 0);
        result = 31 * result + (this.actualEndDate != null ? this.actualEndDate.hashCode() : 0);
        result = 31 * result + (this.from != null ? this.from.hashCode() : 0);
        result = 31 * result + (this.to != null ? this.to.hashCode() : 0);
        result = 31 * result + this.page;
        result = 31 * result + this.itemsPerPage;
        return result;
    }

    @Nonnull
    public MenigaFeed subList(int fromIndex, int toIndex) {
        List items = super.subList(fromIndex, toIndex);
        MenigaFeed clone = this.clone();
        clone.clear();
        clone.addAll(items);
        return clone;
    }

    public static Result<MenigaFeed> fetch(DateTime from, DateTime to) {
        FeedFilter feedFilter = new FeedFilter.Builder().from(from).to(to).build();
        return MenigaFeed.fetch(feedFilter);
    }

    public static Result<MenigaFeed> fetch(DateTime from, DateTime to, int page, int itemsPerPage) {
        FeedFilter feedFilter = new FeedFilter.Builder().from(from).to(to).page(page).itemsPerPage(itemsPerPage).build();
        return MenigaFeed.fetch(feedFilter);
    }

    public static Result<MenigaFeed> fetch(final @Nonnull FeedFilter feedFilter) {
        Result<MenigaFeed> task2 = apiOperator.getFeed(feedFilter);
        return MenigaSDK.getMenigaSettings().getTaskAdapter().intercept(task2, new Interceptor<MenigaFeed>(){

            @Override
            public void onFinished(MenigaFeed result, boolean failed) {
                if (!failed && result != null) {
                    result.from = feedFilter.getFrom();
                    result.to = feedFilter.getTo();
                    if (feedFilter.getPage() != null) {
                        result.page = feedFilter.getPage();
                    }
                    if (feedFilter.getItemsPerPage() != null) {
                        result.itemsPerPage = feedFilter.getItemsPerPage();
                    }
                }
            }
        });
    }

    public Result<MenigaFeed> appendDays(final int numDays) {
        FeedFilter.Builder builder = new FeedFilter.Builder().from(this.from.minusDays(numDays)).to(this.from.minusMillis(1));
        if (this.itemsPerPage > 0) {
            this.page = 0;
            builder.page(this.page).itemsPerPage(this.itemsPerPage);
        }
        Result<MenigaFeed> task2 = apiOperator.getFeed(builder.build());
        return MenigaSDK.getMenigaSettings().getTaskAdapter().intercept(task2, new Interceptor<MenigaFeed>(){

            @Override
            public void onFinished(MenigaFeed result, boolean failed) {
                if (!failed && result != null) {
                    MenigaFeed.this.addAll(result);
                    MenigaFeed.this.totalCount = result.totalCount;
                    MenigaFeed.this.actualEndDate = result.actualEndDate;
                    MenigaFeed.this.from = MenigaFeed.this.from.minusDays(numDays);
                }
            }
        });
    }

    public Result<MenigaFeed> appendNextPage() {
        FeedFilter feedFilter = new FeedFilter.Builder().from(this.from).to(this.to).page(this.page + 1).itemsPerPage(this.itemsPerPage).build();
        Result<MenigaFeed> task2 = apiOperator.getFeed(feedFilter);
        return MenigaSDK.getMenigaSettings().getTaskAdapter().intercept(task2, new Interceptor<MenigaFeed>(){

            @Override
            public void onFinished(MenigaFeed result, boolean failed) {
                if (!failed && result != null) {
                    MenigaFeed.this.addAll(result);
                    MenigaFeed.this.totalCount = result.totalCount;
                    MenigaFeed.this.actualEndDate = result.actualEndDate;
                    ++MenigaFeed.this.page;
                }
            }
        });
    }

    public Result<MenigaFeed> nextPage() {
        FeedFilter feedFilter = new FeedFilter.Builder().from(this.from).to(this.to).page(this.page + 1).itemsPerPage(this.itemsPerPage).build();
        Result<MenigaFeed> task2 = apiOperator.getFeed(feedFilter);
        return MenigaSDK.getMenigaSettings().getTaskAdapter().intercept(task2, new Interceptor<MenigaFeed>(){

            @Override
            public void onFinished(MenigaFeed result, boolean failed) {
                if (!failed && result != null) {
                    MenigaFeed.this.clear();
                    MenigaFeed.this.addAll(result);
                    MenigaFeed.this.totalCount = result.totalCount;
                    MenigaFeed.this.actualEndDate = result.actualEndDate;
                    ++MenigaFeed.this.page;
                }
            }
        });
    }

    public Result<MenigaFeed> prevPage() {
        FeedFilter feedFilter = new FeedFilter.Builder().from(this.from).to(this.to).page(this.page - 1).itemsPerPage(this.itemsPerPage).build();
        Result<MenigaFeed> task2 = apiOperator.getFeed(feedFilter);
        return MenigaSDK.getMenigaSettings().getTaskAdapter().intercept(task2, new Interceptor<MenigaFeed>(){

            @Override
            public void onFinished(MenigaFeed result, boolean failed) {
                if (!failed && result != null) {
                    MenigaFeed.this.clear();
                    MenigaFeed.this.addAll(result);
                    MenigaFeed.this.totalCount = result.totalCount;
                    MenigaFeed.this.setActualEndDate(result.actualEndDate);
                    --MenigaFeed.this.page;
                }
            }
        });
    }

    public static Result<MenigaScheduledEvent> fetchScheduledEvent(long id) {
        return apiOperator.getScheduledEvent(id);
    }
}

