/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.feed;

import android.os.Parcel;
import android.os.Parcelable;
import com.meniga.sdk.models.feed.MenigaFeedItem;
import com.meniga.sdk.models.userevents.enums.UserEventType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;

public class MenigaEvent
implements MenigaFeedItem,
Serializable,
Cloneable,
Parcelable {
    protected long id;
    protected long topicId;
    protected String title;
    protected DateTime date;
    protected String body;
    protected UserEventType eventTypeIdentifier;
    protected Map<String, String> messageData;
    protected String topicName;
    public static final Parcelable.Creator<MenigaEvent> CREATOR = new Parcelable.Creator<MenigaEvent>(){

        public MenigaEvent createFromParcel(Parcel source) {
            return new MenigaEvent(source);
        }

        public MenigaEvent[] newArray(int size) {
            return new MenigaEvent[size];
        }
    };

    protected MenigaEvent() {
    }

    public long getId() {
        return this.id;
    }

    public long getTopicId() {
        return this.topicId;
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public DateTime getDate() {
        return this.date;
    }

    @Override
    public MenigaFeedItem clone() throws CloneNotSupportedException {
        return (MenigaEvent)super.clone();
    }

    @Override
    public String getEventTypeIdentifier() {
        return this.eventTypeIdentifier.toString();
    }

    @Override
    public String getTopicName() {
        return null;
    }

    public String getBody() {
        return this.body;
    }

    public UserEventType getEventTypeIdentifierEnum() {
        if (this.eventTypeIdentifier == null) {
            return UserEventType.UNKNOWN;
        }
        return this.eventTypeIdentifier;
    }

    public Map<String, String> getMessageData() {
        return this.messageData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MenigaEvent that = (MenigaEvent)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.topicId != that.topicId) {
            return false;
        }
        if (this.title != null ? !this.title.equals(that.title) : that.title != null) {
            return false;
        }
        if (this.date != null ? !this.date.equals((Object)that.date) : that.date != null) {
            return false;
        }
        if (this.body != null ? !this.body.equals(that.body) : that.body != null) {
            return false;
        }
        if (this.eventTypeIdentifier != that.eventTypeIdentifier) {
            return false;
        }
        return this.messageData != null ? this.messageData.equals(that.messageData) : that.messageData == null;
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (int)(this.topicId ^ this.topicId >>> 32);
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.date != null ? this.date.hashCode() : 0);
        result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
        result = 31 * result + (this.eventTypeIdentifier != null ? this.eventTypeIdentifier.hashCode() : 0);
        result = 31 * result + (this.messageData != null ? this.messageData.hashCode() : 0);
        return result;
    }

    public String toString() {
        return Long.toString(this.topicId) + ": " + (Object)((Object)this.eventTypeIdentifier);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.id);
        dest.writeLong(this.topicId);
        dest.writeString(this.title);
        dest.writeSerializable((Serializable)this.date);
        dest.writeString(this.body);
        dest.writeInt(this.eventTypeIdentifier == null ? -1 : this.eventTypeIdentifier.ordinal());
        dest.writeInt(this.messageData.size());
        for (Map.Entry<String, String> entry : this.messageData.entrySet()) {
            dest.writeString(entry.getKey());
            dest.writeString(entry.getValue());
        }
    }

    protected MenigaEvent(Parcel in) {
        this.id = in.readLong();
        this.topicId = in.readLong();
        this.title = in.readString();
        this.date = (DateTime)in.readSerializable();
        this.body = in.readString();
        int tmpEventTypeIdentifier = in.readInt();
        this.eventTypeIdentifier = tmpEventTypeIdentifier == -1 ? null : UserEventType.values()[tmpEventTypeIdentifier];
        int messageDataSize = in.readInt();
        this.messageData = new HashMap<String, String>(messageDataSize);
        for (int i = 0; i < messageDataSize; ++i) {
            String key = in.readString();
            String value = in.readString();
            this.messageData.put(key, value);
        }
    }
}

