/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.challenges.operators;

import com.meniga.sdk.MenigaSDK;
import com.meniga.sdk.helpers.MenigaDecimal;
import com.meniga.sdk.helpers.PaginationUtils;
import com.meniga.sdk.helpers.Result;
import com.meniga.sdk.models.challenges.CategoryDefinition;
import com.meniga.sdk.models.challenges.FetchChallengeFilter;
import com.meniga.sdk.models.challenges.MenigaChallenge;
import com.meniga.sdk.models.challenges.NewChallenge;
import com.meniga.sdk.models.challenges.enums.CustomChallengeColor;
import com.meniga.sdk.models.challenges.operators.MenigaChallengesOperations;
import com.meniga.sdk.webservices.challenge.AcceptChallenge;
import com.meniga.sdk.webservices.challenge.CreateChallenge;
import com.meniga.sdk.webservices.challenge.DeleteChallenge;
import com.meniga.sdk.webservices.challenge.GetChallenge;
import com.meniga.sdk.webservices.challenge.GetChallengeHistory;
import com.meniga.sdk.webservices.challenge.GetChallenges;
import com.meniga.sdk.webservices.challenge.UpdateChallenge;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J,\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00130\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u001c\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00130\u00042\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00042\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0016\u00a8\u0006\u001d"}, d2={"Lcom/meniga/sdk/models/challenges/operators/MenigaChallengesOperationsImp;", "Lcom/meniga/sdk/models/challenges/operators/MenigaChallengesOperations;", "()V", "acceptChallenge", "Lcom/meniga/sdk/helpers/Result;", "Lcom/meniga/sdk/models/challenges/MenigaChallenge;", "id", "Ljava/util/UUID;", "targetAmount", "Lcom/meniga/sdk/helpers/MenigaDecimal;", "createChallenge", "challenge", "Lcom/meniga/sdk/models/challenges/NewChallenge;", "deleteChallenge", "Ljava/lang/Void;", "disableChallenge", "enableChallenge", "getChallenge", "getChallengeHistory", "", "page", "", "itemsPerPage", "getChallenges", "filter", "Lcom/meniga/sdk/models/challenges/FetchChallengeFilter;", "updateChallenge", "updateCategoryIds", "", "sdk-android_release"})
public final class MenigaChallengesOperationsImp
implements MenigaChallengesOperations {
    @Override
    @NotNull
    public Result<List<MenigaChallenge>> getChallenges(@NotNull FetchChallengeFilter filter) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        GetChallenges request = new GetChallenges(filter.includeExpired, filter.excludeSuggested, filter.excludeAccepted, filter.includeDisabled);
        Result<List<MenigaChallenge>> result = MenigaSDK.executor().getChallenges(request);
        Intrinsics.checkNotNullExpressionValue(result, (String)"MenigaSDK.executor().getChallenges(request)");
        return result;
    }

    @Override
    @NotNull
    public Result<MenigaChallenge> getChallenge(@NotNull UUID id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        GetChallenge req = new GetChallenge(id);
        Result<MenigaChallenge> result = MenigaSDK.executor().getChallenge(req);
        Intrinsics.checkNotNullExpressionValue(result, (String)"MenigaSDK.executor().getChallenge(req)");
        return result;
    }

    @Override
    @NotNull
    public Result<MenigaChallenge> acceptChallenge(@NotNull UUID id, @NotNull MenigaDecimal targetAmount) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)targetAmount, (String)"targetAmount");
        AcceptChallenge req = new AcceptChallenge(null, null, 3, null);
        req.id = id;
        req.targetAmount = targetAmount;
        Result<MenigaChallenge> result = MenigaSDK.executor().acceptChallenge(req);
        Intrinsics.checkNotNullExpressionValue(result, (String)"MenigaSDK.executor().acceptChallenge(req)");
        return result;
    }

    @Override
    @NotNull
    public Result<Void> disableChallenge(@NotNull UUID id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Result<Void> result = MenigaSDK.executor().disableChallenge(id);
        Intrinsics.checkNotNullExpressionValue(result, (String)"MenigaSDK.executor().disableChallenge(id)");
        return result;
    }

    @Override
    @NotNull
    public Result<Void> enableChallenge(@NotNull UUID id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Result<Void> result = MenigaSDK.executor().enableChallenge(id);
        Intrinsics.checkNotNullExpressionValue(result, (String)"MenigaSDK.executor().enableChallenge(id)");
        return result;
    }

    @Override
    @NotNull
    public Result<MenigaChallenge> createChallenge(@NotNull NewChallenge challenge) {
        Intrinsics.checkNotNullParameter((Object)challenge, (String)"challenge");
        CreateChallenge.CreateChallengeTypeData typeData = new CreateChallenge.CreateChallengeTypeData(null, null, null, null, null, 31, null);
        CategoryDefinition categoryDefinition = challenge.categoryDefinition;
        boolean bl = false;
        boolean bl2 = false;
        CategoryDefinition it = categoryDefinition;
        boolean bl3 = false;
        CategoryDefinition categoryDefinition2 = it;
        if (categoryDefinition2 instanceof CategoryDefinition.CategoryList) {
            typeData.setCategoryIds(((CategoryDefinition.CategoryList)it).getCategoryIds());
        } else if (categoryDefinition2 instanceof CategoryDefinition.Type) {
            typeData.setCategoryType(((CategoryDefinition.Type)it).getCategoryType());
        }
        typeData.setTargetAmount(challenge.targetAmount);
        typeData.setRecurringInterval(challenge.recurringInterval);
        if (challenge.customChallengeColor != null) {
            StringBuilder stringBuilder = new StringBuilder().append("{\"color\": \"");
            CustomChallengeColor customChallengeColor = challenge.customChallengeColor;
            Intrinsics.checkNotNull((Object)customChallengeColor);
            typeData.setMetaData(stringBuilder.append(customChallengeColor.toColorString()).append("\"}").toString());
        }
        CreateChallenge req = new CreateChallenge(challenge.title, challenge.description, challenge.startDate, challenge.endDate, challenge.iconUrl, typeData);
        Result<MenigaChallenge> result = MenigaSDK.executor().createChallenge(req);
        Intrinsics.checkNotNullExpressionValue(result, (String)"MenigaSDK.executor().createChallenge(req)");
        return result;
    }

    @Override
    @NotNull
    public Result<Void> updateChallenge(@NotNull MenigaChallenge challenge, boolean updateCategoryIds) {
        Intrinsics.checkNotNullParameter((Object)challenge, (String)"challenge");
        UpdateChallenge req = new UpdateChallenge(null, null, null, null, null, null, null, 127, null);
        req.id = challenge.getId();
        req.title = challenge.getTitle();
        req.description = challenge.getDescription();
        req.startDate = challenge.getStartDate();
        req.endDate = challenge.getEndDate();
        req.iconUrl = challenge.getIconUrl();
        req.typeData = new UpdateChallenge.TypeData(null, null, null, 7, null);
        Intrinsics.checkNotNull((Object)req.typeData);
        req.typeData.targetAmount = challenge.getTargetAmount();
        if (updateCategoryIds) {
            Intrinsics.checkNotNull((Object)req.typeData);
            req.typeData.categoryIds = challenge.getCategoryIds();
        }
        if (challenge.getCustomChallengeColor() != null) {
            Intrinsics.checkNotNull((Object)req.typeData);
            req.typeData.metaData = "{\"color\": \"" + challenge.getCustomChallengeColor().toColorString() + "\"}";
        }
        Result<Void> result = MenigaSDK.executor().updateChallenge(req);
        Intrinsics.checkNotNullExpressionValue(result, (String)"MenigaSDK.executor().updateChallenge(req)");
        return result;
    }

    @Override
    @NotNull
    public Result<Void> deleteChallenge(@NotNull UUID id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        DeleteChallenge req = new DeleteChallenge(id);
        Result<Void> result = MenigaSDK.executor().deleteChallenge(req);
        Intrinsics.checkNotNullExpressionValue(result, (String)"MenigaSDK.executor().deleteChallenge(req)");
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Result<List<MenigaChallenge>> getChallengeHistory(@NotNull UUID id, int page, int itemsPerPage) {
        void skip;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Pair<Integer, Integer> pair = PaginationUtils.toSkipAndTake(page, itemsPerPage);
        int n = ((Number)pair.component1()).intValue();
        int take = ((Number)pair.component2()).intValue();
        GetChallengeHistory request = new GetChallengeHistory(id, (int)skip, take);
        Result<List<MenigaChallenge>> result = MenigaSDK.executor().getChallengeHistory(request);
        Intrinsics.checkNotNullExpressionValue(result, (String)"MenigaSDK.executor().getChallengeHistory(request)");
        return result;
    }
}

