/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.categories;

import android.os.Parcel;
import android.os.Parcelable;
import com.meniga.sdk.MenigaSDK;
import com.meniga.sdk.helpers.Interceptor;
import com.meniga.sdk.helpers.Result;
import com.meniga.sdk.models.Merge;
import com.meniga.sdk.models.categories.MenigaCategory;
import com.meniga.sdk.models.categories.enums.CategoryType;
import java.io.Serializable;

public class MenigaUserCategory
extends MenigaCategory
implements Serializable {
    public static final Parcelable.Creator<MenigaUserCategory> CREATOR = new Parcelable.Creator<MenigaUserCategory>(){

        public MenigaUserCategory createFromParcel(Parcel source) {
            return new MenigaUserCategory(source);
        }

        public MenigaUserCategory[] newArray(int size) {
            return new MenigaUserCategory[size];
        }
    };

    public MenigaUserCategory(MenigaCategory toCopy) {
        this.id = toCopy.id;
        this.name = toCopy.name;
        this.otherCategoryName = toCopy.otherCategoryName;
        this.categoryDisplay = toCopy.categoryDisplay;
        this.parentCategoryId = toCopy.parentCategoryId;
        this.isPublic = true;
        this.isFixedExpenses = toCopy.isFixedExpenses;
        this.categoryType = toCopy.categoryType;
        this.categoryRank = toCopy.categoryRank;
        this.budgetGenerationType = toCopy.budgetGenerationType;
        this.children = toCopy.children;
        this.parent = toCopy.parent;
        this.categoryContextId = toCopy.categoryContextId;
        this.orderId = toCopy.orderId;
        this.displayData = toCopy.displayData;
        this.fixedIcon = toCopy.fixedIcon;
    }

    protected MenigaUserCategory(Parcel in) {
        super(in);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setIsFixedExpenses(boolean isFixedExpenses) {
        this.isFixedExpenses = isFixedExpenses;
    }

    public void setCategoryType(CategoryType categoryType) {
        this.categoryType = categoryType;
    }

    public void setParentCategoryId(long parentCategoryId) {
        this.parentCategoryId = parentCategoryId;
    }

    public Result<Void> delete() {
        return apiOperator.deleteUserCategory(this.id);
    }

    public Result<Void> update() {
        return apiOperator.updateUserCategory(this.id, this.name, this.isFixedExpenses, this.categoryType, this.parentCategoryId);
    }

    public Result<MenigaCategory> refresh() {
        Result<MenigaCategory> task2 = MenigaUserCategory.fetch(this.id);
        return MenigaSDK.getMenigaSettings().getTaskAdapter().intercept(task2, new Interceptor<MenigaCategory>(){

            @Override
            public void onFinished(MenigaCategory result, boolean failed) {
                if (!failed) {
                    try {
                        Merge.merge(MenigaUserCategory.this, result);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public static Result<MenigaUserCategory> create(String name, boolean isFixedExpenses, long parentId) {
        return apiOperator.createUserCategory(name, isFixedExpenses, CategoryType.EXPENSES, parentId);
    }

    public static Result<MenigaUserCategory> create(String name, boolean isFixedExpenses, CategoryType type2) {
        return apiOperator.createUserCategory(name, isFixedExpenses, type2, null);
    }
}

