/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.categories;

import android.os.Parcel;
import android.os.Parcelable;
import com.meniga.sdk.MenigaSDK;
import com.meniga.sdk.helpers.Result;
import com.meniga.sdk.models.categories.enums.CategoryRequest;
import com.meniga.sdk.models.categories.enums.CategoryType;
import com.meniga.sdk.models.categories.operators.MenigaCategoryOperations;
import com.meniga.sdk.providers.tasks.Continuation;
import com.meniga.sdk.providers.tasks.Task;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MenigaCategory
implements Parcelable,
Serializable,
Cloneable {
    public static final Parcelable.Creator<MenigaCategory> CREATOR = new Parcelable.Creator<MenigaCategory>(){

        public MenigaCategory createFromParcel(Parcel source) {
            return new MenigaCategory(source);
        }

        public MenigaCategory[] newArray(int size) {
            return new MenigaCategory[size];
        }
    };
    protected static MenigaCategoryOperations apiOperator;
    protected long id;
    protected String name;
    protected String otherCategoryName;
    protected String categoryDisplay;
    protected Long parentCategoryId;
    protected Boolean isPublic;
    protected Boolean isFixedExpenses;
    protected CategoryType categoryType;
    protected String categoryRank;
    protected Integer budgetGenerationType;
    protected List<MenigaCategory> children = new ArrayList<MenigaCategory>();
    protected MenigaCategory parent;
    protected Integer categoryContextId;
    protected Integer orderId;
    protected String displayData;
    protected String fixedIcon;

    protected MenigaCategory() {
    }

    protected MenigaCategory(Parcel in) {
        this.id = in.readLong();
        this.name = in.readString();
        this.otherCategoryName = in.readString();
        this.categoryDisplay = in.readString();
        this.parentCategoryId = (Long)in.readValue(Long.class.getClassLoader());
        this.isPublic = (Boolean)in.readValue(Boolean.class.getClassLoader());
        this.isFixedExpenses = (Boolean)in.readValue(Boolean.class.getClassLoader());
        int tmpCategoryType = in.readInt();
        this.categoryType = tmpCategoryType == -1 ? null : CategoryType.values()[tmpCategoryType];
        this.categoryRank = in.readString();
        this.budgetGenerationType = (Integer)in.readValue(Integer.class.getClassLoader());
        this.children = in.createTypedArrayList(CREATOR);
        this.categoryContextId = (Integer)in.readValue(Integer.class.getClassLoader());
        this.orderId = (Integer)in.readValue(Integer.class.getClassLoader());
        this.displayData = in.readString();
        this.fixedIcon = in.readString();
        if (this.children != null) {
            for (MenigaCategory child : this.children) {
                child.parent = this;
            }
        }
    }

    public static void setOperator(MenigaCategoryOperations operator) {
        apiOperator = operator;
    }

    protected MenigaCategory clone() throws CloneNotSupportedException {
        return (MenigaCategory)super.clone();
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getOtherCategoryName() {
        return this.otherCategoryName;
    }

    public String getCategoryDisplay() {
        return this.categoryDisplay;
    }

    public Long getParentCategoryId() {
        return this.parentCategoryId;
    }

    public Boolean getIsPublic() {
        return this.isPublic;
    }

    public Boolean getIsFixedExpenses() {
        return this.isFixedExpenses;
    }

    public CategoryType getCategoryType() {
        return this.categoryType;
    }

    public String getCategoryRank() {
        return this.categoryRank;
    }

    public Integer getBudgetGenerationType() {
        return this.budgetGenerationType;
    }

    public List<MenigaCategory> getChildren() {
        return this.children;
    }

    public MenigaCategory getParent() {
        return this.parent;
    }

    public Integer getCategoryContextId() {
        return this.categoryContextId;
    }

    public Integer getOrderId() {
        return this.orderId;
    }

    public String getDisplayData() {
        return this.displayData;
    }

    public String getFixedIcon() {
        return this.fixedIcon;
    }

    public String toString() {
        if (this.name == null) {
            return "null";
        }
        return this.id + ": " + this.name;
    }

    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MenigaCategory that = (MenigaCategory)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.otherCategoryName != null ? !this.otherCategoryName.equals(that.otherCategoryName) : that.otherCategoryName != null) {
            return false;
        }
        if (this.categoryDisplay != null ? !this.categoryDisplay.equals(that.categoryDisplay) : that.categoryDisplay != null) {
            return false;
        }
        if (this.parentCategoryId != null ? !this.parentCategoryId.equals(that.parentCategoryId) : that.parentCategoryId != null) {
            return false;
        }
        if (this.isPublic != null ? !this.isPublic.equals(that.isPublic) : that.isPublic != null) {
            return false;
        }
        if (this.isFixedExpenses != null ? !this.isFixedExpenses.equals(that.isFixedExpenses) : that.isFixedExpenses != null) {
            return false;
        }
        if (this.categoryType != that.categoryType) {
            return false;
        }
        if (this.categoryRank != null ? !this.categoryRank.equals(that.categoryRank) : that.categoryRank != null) {
            return false;
        }
        if (this.budgetGenerationType != null ? !this.budgetGenerationType.equals(that.budgetGenerationType) : that.budgetGenerationType != null) {
            return false;
        }
        if (this.children != null ? !this.children.equals(that.children) : that.children != null) {
            return false;
        }
        if (this.parent == null && that.parent != null || this.parent != null && that.parent == null) {
            return false;
        }
        if (this.parent != null && this.parent.getId() != that.parent.getId()) {
            return false;
        }
        if (this.categoryContextId != null ? !this.categoryContextId.equals(that.categoryContextId) : that.categoryContextId != null) {
            return false;
        }
        if (this.orderId != null ? !this.orderId.equals(that.orderId) : that.orderId != null) {
            return false;
        }
        if (this.displayData != null ? !this.displayData.equals(that.displayData) : that.displayData != null) {
            return false;
        }
        return this.fixedIcon != null ? this.fixedIcon.equals(that.fixedIcon) : that.fixedIcon == null;
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.otherCategoryName != null ? this.otherCategoryName.hashCode() : 0);
        result = 31 * result + (this.categoryDisplay != null ? this.categoryDisplay.hashCode() : 0);
        result = 31 * result + (this.parentCategoryId != null ? this.parentCategoryId.hashCode() : 0);
        result = 31 * result + (this.isPublic != null ? this.isPublic.hashCode() : 0);
        result = 31 * result + (this.isFixedExpenses != null ? this.isFixedExpenses.hashCode() : 0);
        result = 31 * result + (this.categoryType != null ? this.categoryType.hashCode() : 0);
        result = 31 * result + (this.categoryRank != null ? this.categoryRank.hashCode() : 0);
        result = 31 * result + (this.budgetGenerationType != null ? this.budgetGenerationType.hashCode() : 0);
        result = 31 * result + (this.children != null ? this.children.hashCode() : 0);
        result = 31 * result + (this.parent != null ? this.parent.hashCode() : 0);
        result = 31 * result + (this.categoryContextId != null ? this.categoryContextId.hashCode() : 0);
        result = 31 * result + (this.orderId != null ? this.orderId.hashCode() : 0);
        result = 31 * result + (this.displayData != null ? this.displayData.hashCode() : 0);
        result = 31 * result + (this.fixedIcon != null ? this.fixedIcon.hashCode() : 0);
        return result;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.id);
        dest.writeString(this.name);
        dest.writeString(this.otherCategoryName);
        dest.writeString(this.categoryDisplay);
        dest.writeValue((Object)this.parentCategoryId);
        dest.writeValue((Object)this.isPublic);
        dest.writeValue((Object)this.isFixedExpenses);
        dest.writeInt(this.categoryType == null ? -1 : this.categoryType.ordinal());
        dest.writeString(this.categoryRank);
        dest.writeValue((Object)this.budgetGenerationType);
        if (this.children != null) {
            MenigaCategory self = null;
            for (MenigaCategory cat : this.children) {
                if (cat.getId() != this.id) continue;
                self = cat;
                break;
            }
            if (self != null) {
                this.children.remove(self);
            }
        }
        dest.writeTypedList(this.children);
        dest.writeValue((Object)this.categoryContextId);
        dest.writeValue((Object)this.orderId);
        dest.writeString(this.displayData);
        dest.writeString(this.fixedIcon);
    }

    public static Result<List<MenigaCategory>> fetch() {
        return apiOperator.getCategories(false, MenigaSDK.getMenigaSettings().getCulture());
    }

    public static Result<List<MenigaCategory>> fetchTree(CategoryRequest type2) {
        Boolean publicOnly = false;
        if (type2 == CategoryRequest.ONLY_SYSTEM_CATEGORIES) {
            publicOnly = true;
        }
        Result<List<MenigaCategory>> task2 = apiOperator.getCategoriesTree(publicOnly, MenigaSDK.getMenigaSettings().getCulture());
        task2.getTask().continueWith(new Continuation<List<MenigaCategory>, Object>(){

            @Override
            public Object then(Task<List<MenigaCategory>> task2) throws Exception {
                if (!task2.isFaulted() && task2.getResult() != null) {
                    ArrayList<MenigaCategory> roots = new ArrayList<MenigaCategory>();
                    for (MenigaCategory cat : task2.getResult()) {
                        if (cat.parentCategoryId != null) continue;
                        roots.add(cat);
                    }
                    for (MenigaCategory root : roots) {
                        root.getChildren().clear();
                        HashMap<Long, Boolean> duplicateCheck = new HashMap<Long, Boolean>();
                        for (MenigaCategory child : task2.getResult()) {
                            if (child.parentCategoryId == null || child.parentCategoryId != root.id || duplicateCheck.containsKey(child.getId())) continue;
                            duplicateCheck.put(child.getId(), true);
                            root.getChildren().add(child);
                            child.parent = root;
                        }
                    }
                    task2.getResult().clear();
                    for (MenigaCategory root : roots) {
                        task2.getResult().add(root);
                    }
                }
                return task2.getResult();
            }
        });
        return task2;
    }

    public static Result<List<MenigaCategory>> fetch(CategoryRequest type2) {
        boolean publicOnly = true;
        if (type2 == CategoryRequest.ALL) {
            publicOnly = false;
        }
        return apiOperator.getCategories(publicOnly, MenigaSDK.getMenigaSettings().getCulture());
    }

    public static Result<MenigaCategory> fetch(long id) {
        return apiOperator.getCategoryById(id, MenigaSDK.getMenigaSettings().getCulture());
    }
}

