/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.budget;

import com.meniga.sdk.helpers.Objects;
import com.meniga.sdk.models.budget.NewBudgetRule;
import com.meniga.sdk.webservices.budget.CreateBudgetRules;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class NewBudgetRules {
    private final long budgetId;
    private final List<NewBudgetRule> newBudgetRules;

    private NewBudgetRules(long budgetId, @Nonnull List<NewBudgetRule> newBudgetRules) {
        Objects.checkArgument(!newBudgetRules.isEmpty(), "Should contain at least one new rule");
        this.budgetId = budgetId;
        this.newBudgetRules = newBudgetRules;
    }

    public static Builder withBudgetId(long budgetId) {
        return new Builder(budgetId);
    }

    public long getBudgetId() {
        return this.budgetId;
    }

    public CreateBudgetRules toCreateBudgetRules() {
        ArrayList<CreateBudgetRules.CreateBudgetRuleData> createBudgetRuleDataList = new ArrayList<CreateBudgetRules.CreateBudgetRuleData>();
        for (NewBudgetRule newBudgetRule : this.newBudgetRules) {
            createBudgetRuleDataList.add(newBudgetRule.toCreateBudgetRulesData());
        }
        return new CreateBudgetRules(createBudgetRuleDataList);
    }

    public static final class Builder {
        private long budgetId;
        private List<NewBudgetRule> newBudgetRules = new ArrayList<NewBudgetRule>();

        private Builder(long budgetId) {
            this.budgetId = budgetId;
        }

        public Builder addRule(@Nonnull NewBudgetRule newBudgetRule) {
            this.newBudgetRules.add(Objects.requireNonNull(newBudgetRule));
            return this;
        }

        public NewBudgetRules build() {
            return new NewBudgetRules(this.budgetId, this.newBudgetRules);
        }
    }
}

