/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.budget;

import android.os.Parcel;
import android.os.Parcelable;
import com.meniga.sdk.helpers.MenigaDecimal;
import com.meniga.sdk.helpers.Result;
import com.meniga.sdk.models.budget.FetchBudgetRulesFilter;
import com.meniga.sdk.models.budget.NewBudgetRules;
import com.meniga.sdk.models.budget.TargetAmountGeneration;
import com.meniga.sdk.models.budget.operators.MenigaBudgetOperations;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public class MenigaBudgetRule
implements Parcelable,
Serializable {
    private static MenigaBudgetOperations apiOperator;
    protected long id;
    protected MenigaDecimal targetAmount;
    protected DateTime startDate;
    protected DateTime endDate;
    protected DateTime updatedAt;
    protected long budgetId;
    protected int generationType;
    protected List<Long> categoryIds;
    public static final Parcelable.Creator<MenigaBudgetRule> CREATOR;

    public long getId() {
        return this.id;
    }

    @Nonnull
    public MenigaDecimal getTargetAmount() {
        return this.targetAmount;
    }

    @Nonnull
    public DateTime getStartDate() {
        return this.startDate;
    }

    @Nullable
    public DateTime getEndDate() {
        return this.endDate;
    }

    @Nonnull
    public DateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public long getBudgetId() {
        return this.budgetId;
    }

    public TargetAmountGeneration getTargetAmountGeneration() {
        return TargetAmountGeneration.create(this.generationType);
    }

    @Nonnull
    public List<Long> getCategoryIds() {
        return this.categoryIds;
    }

    public static void setOperator(MenigaBudgetOperations operator) {
        apiOperator = operator;
    }

    public Result<Void> delete() {
        return apiOperator.deleteBudgetRule(this.budgetId, this.id);
    }

    public static Result<List<MenigaBudgetRule>> fetch(FetchBudgetRulesFilter filter) {
        return apiOperator.getBudgetRules(filter.toGetBudgetRules());
    }

    public static Result<List<MenigaBudgetRule>> create(NewBudgetRules budgetRules) {
        return apiOperator.createBudgetRules(budgetRules.getBudgetId(), budgetRules.toCreateBudgetRules());
    }

    private MenigaBudgetRule() {
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.id);
        dest.writeSerializable((Serializable)this.targetAmount);
        dest.writeSerializable((Serializable)this.startDate);
        dest.writeSerializable((Serializable)this.endDate);
        dest.writeSerializable((Serializable)this.updatedAt);
        dest.writeLong(this.budgetId);
        dest.writeInt(this.generationType);
        dest.writeList(this.categoryIds);
    }

    protected MenigaBudgetRule(Parcel in) {
        this.id = in.readLong();
        this.targetAmount = (MenigaDecimal)in.readSerializable();
        this.startDate = (DateTime)in.readSerializable();
        this.endDate = (DateTime)in.readSerializable();
        this.updatedAt = (DateTime)in.readSerializable();
        this.budgetId = in.readLong();
        this.generationType = in.readInt();
        this.categoryIds = new ArrayList<Long>();
        in.readList(this.categoryIds, Long.class.getClassLoader());
    }

    static {
        CREATOR = new Parcelable.Creator<MenigaBudgetRule>(){

            public MenigaBudgetRule createFromParcel(Parcel source) {
                return new MenigaBudgetRule(source);
            }

            public MenigaBudgetRule[] newArray(int size) {
                return new MenigaBudgetRule[size];
            }
        };
    }
}

