/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.budget;

import android.os.Parcel;
import android.os.Parcelable;
import com.meniga.sdk.helpers.Objects;
import com.meniga.sdk.helpers.Result;
import com.meniga.sdk.models.budget.BudgetUpdate;
import com.meniga.sdk.models.budget.BudgetUpdateExtensions;
import com.meniga.sdk.models.budget.FetchBudgetFilter;
import com.meniga.sdk.models.budget.FetchBudgetFilterExtensions;
import com.meniga.sdk.models.budget.FetchBudgetsFilter;
import com.meniga.sdk.models.budget.FetchBudgetsFilterExtensions;
import com.meniga.sdk.models.budget.NewBudget;
import com.meniga.sdk.models.budget.NewBudgetExtensions;
import com.meniga.sdk.models.budget.NewPlanningBudget;
import com.meniga.sdk.models.budget.NewPlanningBudgetExtensions;
import com.meniga.sdk.models.budget.enums.BudgetPeriod;
import com.meniga.sdk.models.budget.enums.BudgetType;
import com.meniga.sdk.models.budget.operators.MenigaBudgetOperations;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public class MenigaBudget
implements Parcelable,
Serializable {
    protected static MenigaBudgetOperations apiOperator;
    protected long id;
    protected BudgetType type;
    protected String name;
    protected String description;
    protected List<Long> accountIds;
    protected BudgetPeriod period;
    protected int offset;
    protected DateTime created;
    public static final Parcelable.Creator<MenigaBudget> CREATOR;

    protected MenigaBudget() {
    }

    public long getId() {
        return this.id;
    }

    public BudgetType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Long> getAccountIds() {
        return this.accountIds;
    }

    public BudgetPeriod getPeriod() {
        return this.period;
    }

    public int getOffset() {
        return this.offset;
    }

    public DateTime getCreated() {
        return this.created;
    }

    public static void setOperator(MenigaBudgetOperations operator) {
        apiOperator = operator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MenigaBudget that = (MenigaBudget)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.offset != that.offset) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.accountIds != null ? !this.accountIds.equals(that.accountIds) : that.accountIds != null) {
            return false;
        }
        if (this.period != that.period) {
            return false;
        }
        return this.created != null ? this.created.equals((Object)that.created) : that.created == null;
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.accountIds != null ? this.accountIds.hashCode() : 0);
        result = 31 * result + (this.period != null ? this.period.hashCode() : 0);
        result = 31 * result + this.offset;
        result = 31 * result + (this.created != null ? this.created.hashCode() : 0);
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.id);
        dest.writeInt(this.type == null ? -1 : this.type.ordinal());
        dest.writeString(this.name);
        dest.writeString(this.description);
        dest.writeList(this.accountIds);
        dest.writeInt(this.period == null ? -1 : this.period.ordinal());
        dest.writeInt(this.offset);
        dest.writeSerializable((Serializable)this.created);
    }

    protected MenigaBudget(Parcel in) {
        this.id = in.readLong();
        int tmpType = in.readInt();
        this.type = tmpType == -1 ? null : BudgetType.values()[tmpType];
        this.name = in.readString();
        this.description = in.readString();
        this.accountIds = new ArrayList<Long>();
        in.readList(this.accountIds, Long.class.getClassLoader());
        int tmpPeriod = in.readInt();
        this.period = tmpPeriod == -1 ? null : BudgetPeriod.values()[tmpPeriod];
        this.offset = in.readInt();
        this.created = (DateTime)in.readSerializable();
    }

    @Deprecated
    public static Result<List<MenigaBudget>> fetch() {
        FetchBudgetsFilter parameters = new FetchBudgetsFilter();
        parameters.setType(BudgetType.PLANNING);
        return MenigaBudget.fetch(parameters);
    }

    public static Result<List<MenigaBudget>> fetch(FetchBudgetsFilter filter) {
        return apiOperator.getBudgets(FetchBudgetsFilterExtensions.toGetBudgets(filter));
    }

    public static Result<MenigaBudget> fetch(FetchBudgetFilter filter) {
        return apiOperator.getBudget(FetchBudgetFilterExtensions.toGetBudget(filter));
    }

    @Deprecated
    public static Result<MenigaBudget> create(@Nonnull BudgetType type2, @Nonnull String name, @Nullable String description, @Nullable List<Long> accountIds, @Nullable BudgetPeriod period) {
        return MenigaBudget.create(type2, name, description, accountIds, period, null);
    }

    @Deprecated
    public static Result<MenigaBudget> create(@Nonnull BudgetType type2, @Nonnull String name, @Nullable String description, @Nullable List<Long> accountIds, @Nullable BudgetPeriod period, @Nullable Integer periodOffset) {
        if (type2 == BudgetType.BUDGET) {
            NewBudget budget = new NewBudget(name);
            budget.setDescription(description);
            budget.setAccountIds(accountIds);
            return MenigaBudget.create(budget);
        }
        NewPlanningBudget budget = new NewPlanningBudget(name);
        budget.setDescription(description);
        budget.setAccountIds(accountIds);
        budget.setPeriod(period);
        budget.setPeriodOffset(periodOffset);
        return MenigaBudget.create(budget);
    }

    public static Result<MenigaBudget> create(@Nonnull NewBudget budget) {
        Objects.requireNonNull(budget);
        return apiOperator.createBudget(NewBudgetExtensions.toCreateBudget(budget));
    }

    public static Result<MenigaBudget> create(@Nonnull NewPlanningBudget budget) {
        Objects.requireNonNull(budget);
        return apiOperator.createBudget(NewPlanningBudgetExtensions.toCreateBudget(budget));
    }

    public Result<Void> delete() {
        return apiOperator.deleteBudget(this.id);
    }

    public Result<Void> reset() {
        return apiOperator.resetBudget(this.id);
    }

    public Result<MenigaBudget> update(BudgetUpdate parameters) {
        return apiOperator.updateBudget(this.id, BudgetUpdateExtensions.toUpdateBudget(parameters));
    }

    static {
        CREATOR = new Parcelable.Creator<MenigaBudget>(){

            public MenigaBudget createFromParcel(Parcel source) {
                return new MenigaBudget(source);
            }

            public MenigaBudget[] newArray(int size) {
                return new MenigaBudget[size];
            }
        };
    }
}

