/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.budget;

import com.meniga.sdk.helpers.Objects;
import com.meniga.sdk.webservices.budget.GetBudgetRules;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public class FetchBudgetRulesFilter {
    private final Long budgetId;
    private final List<Long> categoryIds;
    private final DateTime startDate;
    private final DateTime endDate;
    private final boolean allowOverlappingRules;

    public Long getBudgetId() {
        return this.budgetId;
    }

    public List<Long> getCategoryIds() {
        return this.categoryIds;
    }

    public DateTime getStartDate() {
        return this.startDate;
    }

    public DateTime getEndDate() {
        return this.endDate;
    }

    public boolean isAllowOverlappingRules() {
        return this.allowOverlappingRules;
    }

    private FetchBudgetRulesFilter(@Nonnull Long budgetId, @Nullable List<Long> categoryIds, @Nullable DateTime startDate, @Nullable DateTime endDate, boolean allowOverlappingRules) {
        this.budgetId = Objects.requireNonNull(budgetId);
        this.categoryIds = categoryIds;
        this.startDate = startDate;
        this.endDate = endDate;
        this.allowOverlappingRules = allowOverlappingRules;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public GetBudgetRules toGetBudgetRules() {
        return new GetBudgetRules(this.budgetId, this.categoryIds, this.startDate, this.endDate, this.allowOverlappingRules);
    }

    public static final class Builder {
        private Long budgetId;
        private List<Long> categoryIds;
        private DateTime startDate;
        private DateTime endDate;
        private boolean allowOverlappingRules;

        private Builder() {
        }

        public Builder budgetId(long budgetId) {
            this.budgetId = budgetId;
            return this;
        }

        public Builder categoryIds(List<Long> categoryIds) {
            this.categoryIds = categoryIds;
            return this;
        }

        public Builder startDate(DateTime startDate) {
            this.startDate = startDate;
            return this;
        }

        public Builder endDate(DateTime endDate) {
            this.endDate = endDate;
            return this;
        }

        public Builder allowOverlappingRules(boolean allowOverlappingRules) {
            this.allowOverlappingRules = allowOverlappingRules;
            return this;
        }

        public FetchBudgetRulesFilter build() {
            return new FetchBudgetRulesFilter(this.budgetId, this.categoryIds, this.startDate, this.endDate, this.allowOverlappingRules);
        }
    }
}

