/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.models.accounts.enums;

import java.io.Serializable;
import java.util.Locale;

public enum AccountCategory implements Serializable
{
    WALLET("WALLET"),
    CREDIT("CREDIT"),
    CURRENT("CURRENT"),
    SAVINGS("SAVINGS"),
    MANUAL("MANUAL"),
    LOAN("LOAN"),
    ASSET("ASSET"),
    UNKNOWN("UNKNOWN");

    private String accountCategory;

    private AccountCategory(String accountType) {
        this.accountCategory = accountType.toUpperCase(Locale.getDefault());
    }

    public String toString() {
        return this.accountCategory;
    }

    @Deprecated
    public static AccountCategory fromId(long id) {
        switch ((int)id) {
            case 1: {
                return WALLET;
            }
            case 37: 
            case 46: {
                return CREDIT;
            }
            case 39: {
                return CURRENT;
            }
            case 41: {
                return SAVINGS;
            }
            case 42: {
                return MANUAL;
            }
            case 43: {
                return LOAN;
            }
            case 44: {
                return ASSET;
            }
        }
        return UNKNOWN;
    }
}

