/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.converters;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.meniga.sdk.converters.MenigaConverter;
import com.meniga.sdk.helpers.ChallengeItemFactory;
import com.meniga.sdk.models.challenges.MenigaChallenge;
import com.meniga.sdk.models.challenges.enums.ChallengeType;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Converter;
import retrofit2.Retrofit;

public class MenigaChallengesConverter
extends MenigaConverter {
    private final ChallengeItemFactory factory;

    public MenigaChallengesConverter(ChallengeItemFactory factory) {
        this.factory = factory;
    }

    public Converter<ResponseBody, ?> responseBodyConverter(Type type2, Annotation[] annotations, Retrofit retrofit) {
        Type typeOfChallenge = new TypeToken<MenigaChallenge>(){}.getType();
        Type typeOfChallenges = new TypeToken<List<MenigaChallenge>>(){}.getType();
        if (typeOfChallenge.equals(type2)) {
            return new Converter<ResponseBody, MenigaChallenge>(){

                public MenigaChallenge convert(ResponseBody resBody) throws IOException {
                    return MenigaChallengesConverter.this.factory.getMenigaChallengeItem(MenigaConverter.getAsObject(resBody.byteStream()));
                }
            };
        }
        if (typeOfChallenges.equals(type2)) {
            return new Converter<ResponseBody, Object>(){

                public Object convert(ResponseBody resBody) throws IOException {
                    JsonArray arr = MenigaConverter.getAsArray(resBody.byteStream());
                    ArrayList<MenigaChallenge> challenges = new ArrayList<MenigaChallenge>();
                    for (JsonElement element : arr) {
                        MenigaChallenge challenge = MenigaChallengesConverter.this.factory.getMenigaChallengeItem((JsonObject)element);
                        if (challenge.getTitle().equals("GlobalSpendingMeterMarker")) {
                            challenge.setType(ChallengeType.METER);
                        }
                        challenges.add(challenge);
                    }
                    return challenges;
                }
            };
        }
        return null;
    }

    public Converter<?, RequestBody> requestBodyConverter(Type type2, Annotation[] parameterAnnotations, Annotation[] methodAnnotations, Retrofit retrofit) {
        return null;
    }
}

