/*
 * Decompiled with CFR 0.152.
 */
package com.meniga.sdk.converters;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import com.meniga.sdk.converters.MenigaConverter;
import com.meniga.sdk.helpers.GsonProvider;
import com.meniga.sdk.models.categories.MenigaCategory;
import com.meniga.sdk.models.categories.MenigaUserCategory;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Converter;
import retrofit2.Retrofit;

public class MenigaCategoryConverter
extends MenigaConverter {
    public Converter<ResponseBody, ?> responseBodyConverter(Type type2, Annotation[] annotations, Retrofit retrofit) {
        Type typeOfMenigaCategoryList = new TypeToken<List<MenigaCategory>>(){}.getType();
        Type typeOfMenigaCategory = new TypeToken<MenigaCategory>(){}.getType();
        Type typeOfMenigaUserCategoryList = new TypeToken<List<MenigaUserCategory>>(){}.getType();
        Type typeOfMenigaUserCategory = new TypeToken<MenigaUserCategory>(){}.getType();
        if (typeOfMenigaCategoryList.equals(type2) || typeOfMenigaUserCategoryList.equals(type2)) {
            return new Converter<ResponseBody, Object>(){

                public List<MenigaCategory> convert(ResponseBody resBody) throws IOException {
                    Gson gson2 = GsonProvider.getGson();
                    MenigaCategory[] catsRaw = (MenigaCategory[])gson2.fromJson((JsonElement)MenigaConverter.getAsArray(resBody.byteStream()), MenigaCategory[].class);
                    ArrayList<MenigaCategory> cats = new ArrayList<MenigaCategory>();
                    for (MenigaCategory cat : catsRaw) {
                        if (cat.getIsPublic().booleanValue()) {
                            cats.add(cat);
                        } else {
                            cats.add(new MenigaUserCategory(cat));
                        }
                        for (int i = 0; i < cat.getChildren().size(); ++i) {
                            MenigaCategory child = cat.getChildren().get(i);
                            if (child.getIsPublic().booleanValue()) continue;
                            cat.getChildren().set(i, new MenigaUserCategory(child));
                        }
                    }
                    return cats;
                }
            };
        }
        if (typeOfMenigaCategory.equals(type2) || typeOfMenigaUserCategory.equals(type2)) {
            return new Converter<ResponseBody, Object>(){

                public MenigaCategory convert(ResponseBody resBody) throws IOException {
                    Gson gson2 = GsonProvider.getGson();
                    MenigaCategory catRaw = (MenigaCategory)gson2.fromJson((JsonElement)MenigaConverter.getAsObject(resBody.byteStream()), MenigaCategory.class);
                    if (catRaw.getIsPublic().booleanValue()) {
                        return catRaw;
                    }
                    return new MenigaUserCategory(catRaw);
                }
            };
        }
        return null;
    }

    public Converter<?, RequestBody> requestBodyConverter(Type type2, Annotation[] parameterAnnotations, Annotation[] methodAnnotations, Retrofit retrofit) {
        return null;
    }
}

