/*
 * Decompiled with CFR 0.152.
 */
package com.mediatek.mcs.domain;

import com.mediatek.mcs.R;
import com.mediatek.mcs.domain.DataPointFormatter;
import com.mediatek.mcs.entity.DataPointEntity;
import com.mediatek.mcs.exception.InvalidDataPointException;

public class McsGeoPoint {
    private double latitude;
    private double longitude;
    private double altitude;

    public McsGeoPoint(DataPointEntity.Values values) throws InvalidDataPointException {
        this(Double.toString(values.getLatitude()), Double.toString(values.getLongitude()), Double.toString(values.getAltitude()));
    }

    public McsGeoPoint(String latString, String lngString, String altString) throws InvalidDataPointException {
        if ("".equals(latString) || "".equals(lngString)) {
            throw new InvalidDataPointException(R.string.error_invalid_upload_value);
        }
        if ("".equals(altString)) {
            altString = "0";
        }
        try {
            float latitude = Float.parseFloat(latString);
            float longitude = Float.parseFloat(lngString);
            float altitude = Float.parseFloat(altString);
            this.longitude = -180.0 <= (double)longitude && (double)longitude < 180.0 ? (double)longitude : (((double)longitude - 180.0) % 360.0 + 360.0) % 360.0 - 180.0;
            this.latitude = Math.max(-90.0, Math.min(90.0, (double)latitude));
            this.altitude = altitude;
        }
        catch (NumberFormatException e) {
            throw new InvalidDataPointException(R.string.error_invalid_upload_dp, (Throwable)e);
        }
    }

    public McsGeoPoint trim() throws InvalidDataPointException {
        this.latitude = Double.parseDouble(DataPointFormatter.trimGeoValue(this.latitude));
        this.longitude = Double.parseDouble(DataPointFormatter.trimGeoValue(this.longitude));
        this.altitude = Double.parseDouble(DataPointFormatter.trimGeoValue(this.altitude));
        return this;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getAltitude() {
        return this.altitude;
    }
}

