package com.mediatek.mcs.pref;

import android.content.SharedPreferences.Editor;
import com.mediatek.mcs.entity.McsMobileEntity;
import lombok.Getter;
import lombok.Setter;
import org.json.JSONObject;

public final class McsMobile implements McsPreferences {
  @Getter @Setter private String mobileId;

  final String USER_INFO_MOBILE_ID = "USER_INFO_MOBILE_ID";
  private static McsMobile INSTANCE = new McsMobile();

  private McsMobile() {
    this.mobileId = pref.getString(USER_INFO_MOBILE_ID, "");
  }

  public static McsMobile getInstance() {
    return INSTANCE;
  }

  public void clearPref() {
    this.mobileId = "";
    savePref();
  }

  public void savePref() {
    Editor editor = pref.edit();
    editor.putString(USER_INFO_MOBILE_ID, this.mobileId);
    editor.commit();
  }

  public void saveToPref(JSONObject response) {
    saveUserMobile(gson.fromJson(response.toString(), McsMobileEntity.class));
  }

  private void saveUserMobile(McsMobileEntity mobile) {
    if (!mobile.getMobileId().isEmpty()) {
      this.setMobileId(mobile.getMobileId());
      this.savePref();
    }
  }
}
