package com.mediatek.mcs.net;

import com.mediatek.mcs.Mcs;
import com.mediatek.mcs.R;
import com.mediatek.mcs.entity.DataPointsQuery;

public class RequestApi {
  public static final int DEFAULT_LIMIT = 20;
  public static final int HISTORY_LIMIT = 1000;
  public static final String URL_QUERY_PAGING = "?page={page}&limit={limit}";
  public static final String URL_QUERY_BY_TIME = "?start={start}&end={end}";
  public static final String URL_QUERY_BY_LIMIT = "?offset={offset}&limit={limit}";

  public static final String SIGN_IN = getOauthServer() + "/login/thirdparty";
  public static final String REFRESH_ACCESS_TOKEN = getOauthServer() + "/token/verify/cookies";
  public static final String USER_INFO = getOauthServer() + "/token/info";
  public static final String MOBILES = getServer() + "/mobiles";
  public static final String MOBILE = getServer() + "/mobiles/{mobileId}";

  public static final String DEVICES = getServer() + "/devices";
  public static final String DEVICE = getServer() + "/devices/{deviceId}";

  public static final String DATA_POINTS =
      getServer() + "/devices/{deviceId}/datachannels/{datachannelId}/datapoints";
  public static final String UPLOAD_DATA_POINT = getServer() + "/devices/{deviceId}/datapoints";

  public static final String PROTOTYPES = getServer() + "/products";
  public static final String PROTOTYPE_IMAGE = getServer() + "/products/{productId}/images";
  public static final String DEVICE_NOTIF_GROUPS =
      getServer() + "/devices/{deviceId}/criterions";
  public static final String DEVICE_NOTIF_GROUP =
      getServer() + "/devices/{deviceId}/product/criterions/{criterionId}";
  public static final String DEVICE_FIRMWARE_CANDIDATES =
      getServer() + "/devices/{deviceId}/firmwares/candidate";
  public static final String DEVICE_FIRMWARE =
      getServer() + "/devices/{deviceId}/firmwares/{firmwareId}";
  public static final String HISTORICAL_GRAPH = getResServer()
      + "/graph/{graph}/devices/{deviceId}/devicekey/{deviceKey}/datachannels/{datachannelId}";
  public static final String VIDEO_STREAMING = getResServer()
      + "/videostream/?deviceId={deviceId}&deviceKey={devicekey}&dataChnId={datachannelId}"
      + "&height={height}";

  public static String getServer() {
    return Mcs.getApplicationContext().getString(R.string.mcs_server);
  }

  public static String getOauthServer() {
    return Mcs.getApplicationContext().getString(R.string.mcs_auth_server);
  }

  public static String getResServer() {
    return Mcs.getApplicationContext().getString(R.string.mcs_res_server);
  }

  public static String getSocketServer() {
    return Mcs.getApplicationContext().getString(R.string.mcs_socket_server);
  }

  public static String getLabsServer() {
    return Mcs.getApplicationContext().getString(R.string.mcs_labs_server);
  }

  public static String getImageCdn() {
    return getResServer() + "/img";
  }

  public static String getImageServerPrefix() {
    return getImageServerPrefix(300);
  }

  public static String getImageServerPrefix(final int ImageSize) {
    return Mcs.getApplicationContext().getString(R.string.mcs_image_server)
        + ImageSize + "/mtk.linkit/";
  }

  public static String getImageFileUrl(DataPointsQuery query, String fileName) {
    final String IMAGES = "/{deviceId}/{dataChnId}/";
    return RequestApi.getImageCdn() + IMAGES
        .replace("{deviceId}", query.getDeviceId())
        .replace("{dataChnId}", query.getChannelId())
        + fileName;
  }

  public static String getHistoricalUrl(DataPointsQuery query) {
    String historicalUrl = RequestApi.DATA_POINTS
        .replace("{deviceId}", query.getDeviceId())
        .replace("{datachannelId}", query.getChannelId());

    if (query.getStart() != null && query.getEnd() != null) {
      return historicalUrl + RequestApi.URL_QUERY_BY_TIME
          .replace("{start}", Long.toString(query.getStart()))
          .replace("{end}", Long.toString(query.getEnd()))
          + "&offset=" + Integer.toString(query.getOffset())
          + "&limit=" + Integer.toString(query.getLimit());
    } else {
      return historicalUrl + RequestApi.URL_QUERY_BY_LIMIT
          .replace("{offset}", Integer.toString(query.getOffset()))
          .replace("{limit}", Integer.toString(query.getLimit()));
    }
  }

  public static String setPaging(String url, int page) {
    return setPaging(url, page, DEFAULT_LIMIT);
  }

  public static String setPaging(String url, int page, int limit) {
    return url
        .replace("{page}", Integer.toString(page))
        .replace("{limit}", Integer.toString(limit));
  }
}
