package com.mediatek.mcs.entity.api;

import com.mediatek.mcs.Utils.UIUtils;
import java.util.Date;
import lombok.Getter;

@Getter public class FirmwareEntity extends ApiResults<FirmwareEntity> {
  /**
   * Firmware List
   */
  private String fwId;
  private String name;
  private String version;
  private String description;
  private String url;
  private Date updatedAt;

  /**
   * Firmware Detail
   */
  private String checksum;
  private String[] candidatefwId;
  private boolean defaultprodfw;
  private boolean isSelectAll;
  private boolean isPublic;

  public FirmwareEntity fromJson(String json) {
    return UIUtils.getFormattedGson().fromJson(json, FirmwareEntity.class);
  }

  public String toJson() {
    return UIUtils.getFormattedGson().toJson(this);
  }
}
