package com.mediatek.mcs.entity;

import com.mediatek.mcs.domain.McsGeoPoint;
import lombok.Getter;

/**
 * MCS API schema for parsing data point.
 *
 * class Values could also be used to wrap your
 * to-be-uploaded data with correct format.
 */
@Getter public class DataPointEntity extends McsEntity {
  /**
   * @param recordedAt timeMillis
   */
  private Long recordedAt;
  private Values values;

  @Getter public static class Values {
    private String value;
    private String period;
    private Double latitude;
    private Double longitude;
    private Double altitude;

    /**
     * Wrap data with only value.
     */
    public Values(String value) {
      this.value = value;
    }

    /**
     * Wrap data with both value and period.
     */
    public Values(String value, String period) {
      this.value = value;
      this.period = period;
    }

    public Values(McsGeoPoint geoPoint) {
      this.latitude = geoPoint.getLatitude();
      this.longitude = geoPoint.getLongitude();
      this.altitude = geoPoint.getAltitude();
    }
  }
}
