package com.mediatek.mcs.entity;

import java.util.List;
import lombok.Getter;
import lombok.Setter;

@Getter public class DataChannelEntity extends McsEntity {
  private String dataChnId;
  private String name;
  private String description;
  private ChannelType channelType;
  private Format format;
  private boolean isHidden;
  private boolean isControllable;
  private UnitTypeEntity unitType;
  @Setter private DataPointEntity dataPoint;

  @Getter public class ChannelType {
    private Integer dataChnTypeId;
    private String name;
  }

  @Getter public class Format {
    /**
     * Integer, Float
     */
    private Integer unitTypes;
    private Float lowerbound; // controller only
    private Float upperbound; // controller only

    /**
     * Category
     */
    private List<Result> results;

    @Getter public class Result {
      private String name;
      private String value;
    }

    /**
     * Slider, Gamepad
     */
    private Boolean showCurrent;

    /**
     * Gamepad
     */
    private String up;
    private String right;
    private String down;
    private String left;
    private String actionA;
    private String actionB;
  }
}
