package com.mediatek.mcs.push;

import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import com.mediatek.mcs.Mcs;
import com.mediatek.mcs.McsLog;
import java.io.IOException;

public class PushRegistration {
  private Context context;
  private OnPushRegisteredListener onPushRegisteredListener;

  public interface OnPushRegisteredListener {
    void onSuccess(String regId, boolean isUpdateRegId);
  }

  public PushRegistration(String gcmSenderId, OnPushRegisteredListener listener) {
    this.context = Mcs.getApplicationContext();
    this.onPushRegisteredListener = listener;

    String regId = GcmPreference.getInstance().getRegistrationId(context);

    if (TextUtils.isEmpty(regId)) {
      registerInBackground(gcmSenderId);
    } else {
      onPushRegisteredListener.onSuccess(regId, GcmPreference.getInstance().isUpdateRegId());
    }
  }

  private void registerInBackground(String gcm_sender_id) {
    new AsyncTask<Void, Void, String>() {
      @Override protected String doInBackground(Void... params) {
        String msg = "";
        try {
          String mRegId = GoogleCloudMessaging.getInstance(context).register(gcm_sender_id);
          msg = "Device registered, registration ID = " + mRegId;

          GcmPreference.getInstance().storeRegistrationId(context, mRegId);
          onPushRegisteredListener.onSuccess(mRegId, GcmPreference.getInstance().isUpdateRegId());
        } catch (IOException ex) {
          msg = "Failed to Register GCM. Error :" + ex.getMessage();
          McsLog.e(msg);
        }
        McsLog.d("GCM register msg: " + msg);
        return msg;
      }
    }.execute(null, null, null);
  }
}
