package com.mediatek.mcs.push;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import com.mediatek.mcs.BuildConfig;
import com.mediatek.mcs.Mcs;
import com.mediatek.mcs.McsLog;

public class GcmPreference {

  public static final String PROPERTY_REG_ID = "registration_id";
  private static final String PROPERTY_APP_VERSION = "appVersion";
  private static GcmPreference instance = null;
  boolean isUpdateRegId = false;

  GcmPreference() {
  }

  public static synchronized GcmPreference getInstance() {
    if (instance == null) {
      instance = new GcmPreference();
    }
    return instance;
  }

  public boolean isUpdateRegId() {
    return isUpdateRegId;
  }

  public String getRegistrationId(Context context) {
    final SharedPreferences prefs = getGcmPreferences(context);
    String registrationId = prefs.getString(PROPERTY_REG_ID, "");
    if (registrationId.isEmpty()) {
      McsLog.d("Registration not found.");
      return "";
    }

    int registeredVersion = prefs.getInt(PROPERTY_APP_VERSION, Integer.MIN_VALUE);
    if (registeredVersion != getCurrentVersion()) {
      McsLog.d("App version changed.");
      isUpdateRegId = true;
      return "";
    }

    return registrationId;
  }

  public void storeRegistrationId(Context context, String regId) {
    final SharedPreferences prefs = getGcmPreferences(context);

    SharedPreferences.Editor editor = prefs.edit();
    editor.putString(PROPERTY_REG_ID, regId);
    editor.putInt(PROPERTY_APP_VERSION, getCurrentVersion());
    editor.commit();
  }

  private SharedPreferences getGcmPreferences(Context context) {
    return context.getSharedPreferences(PushRegistration.class.getSimpleName(),
        Context.MODE_PRIVATE);
  }

  private int getCurrentVersion() {
    try {
      return Mcs.getApplicationContext()
          .getPackageManager()
          .getPackageInfo(Mcs.getApplicationContext().getPackageName(), 0).versionCode;
    } catch (PackageManager.NameNotFoundException e) {
      return BuildConfig.VERSION_CODE;
    }
  }
}
