package com.mediatek.mcs.push;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.support.v4.content.WakefulBroadcastReceiver;

public class GcmBroadcastReceiver extends WakefulBroadcastReceiver {

  public static final String GCM_RECEIVE = "com.google.android.c2dm.intent.RECEIVE";

  @Override public void onReceive(Context context, Intent intent) {
    if (GCM_RECEIVE.equals(intent.getAction())) {
      Intent passIntent = new Intent(McsPushBroadcastReceiver.ACTION_RECEIVE);
      passIntent.putExtra(McsPushBroadcastReceiver.KEY_PUSH_DATA, intent.getExtras());
      context.sendBroadcast(passIntent);

      ComponentName comp = new ComponentName(context.getPackageName(), PushService.class.getName());
      startWakefulService(context, (intent.setComponent(comp)));
      setResultCode(Activity.RESULT_OK);
    }
  }
}
