package com.mediatek.mcs.net;

import com.android.volley.AuthFailureError;
import com.android.volley.NetworkError;
import com.android.volley.NoConnectionError;
import com.android.volley.ParseError;
import com.android.volley.ServerError;
import com.android.volley.TimeoutError;
import com.android.volley.VolleyError;
import com.google.gson.Gson;
import com.mediatek.mcs.Mcs;
import com.mediatek.mcs.R;
import com.mediatek.mcs.entity.api.ApiError;
import com.mediatek.mcs.exception.McsNetworkException;
import java.util.HashMap;
import java.util.Map;

public class RequestUtils {

  public static Map<String, String> putAuthHeader(Map<String, String> params) {
    if (params == null) params = new HashMap<>();

    params.put("Content-Type", "application/json");
    params.put("AppId", Mcs.MCS_APP_ID);
    params.put("AppSecret", Mcs.MCS_APP_SECRET);
    return params;
  }

  public static Map<String, String> getSignOutHeader(String accessToken) {
    Map<String, String> params = new HashMap<>();
    params.put("Content-Type", "application/json");
    params.put("Authorization", "Bearer " + accessToken);
    return params;
  }

  public static String parseMcsNetworkError(Throwable error) {
    return parseVolleyError((VolleyError) error).getMessage();
  }

  public static McsNetworkException parseVolleyError(Exception error) {
    if (!(error instanceof VolleyError)) {
      return new McsNetworkException("The error is not a network request", error);
    }

    if (error instanceof NoConnectionError) {
      return new McsNetworkException(R.string.error_network_no_connection, error);
    } else if (error instanceof TimeoutError) {
      return new McsNetworkException(R.string.error_network, error);
    } else if (error instanceof ServerError ||
        error instanceof AuthFailureError ||
        error instanceof NetworkError ||
        error instanceof ParseError) {
      return new McsNetworkException(parseApiError((VolleyError) error), error);
    } else {
      return new McsNetworkException(error.toString(), error);
    }
  }

  public static String parseApiError(VolleyError error) {
    try {
      ApiError apiError =
          new Gson().fromJson(new String(error.networkResponse.data, "utf-8"), ApiError.class);

      String msg = apiError.getMessage();

      return ("".equals(msg)) ? error.toString() : msg;
    } catch (Exception e) {
      return error.toString() + ": " + error.getMessage();
    }
  }
}
