package com.mediatek.mcs.entity;

import com.google.gson.annotations.SerializedName;
import lombok.Getter;

public class AuthEntity extends McsEntity {
  /**
   * /oauth/login/thirdparty
   */
  @Getter public static class Token {
    private String token;
    @SerializedName("access_token") private String accessToken;
  }

  /**
   * /oauth/login/thirdparty/refresh
   */
  @Getter public static class AccessToken {
    private Results results;

    @Getter public static class Results {
      private String token;
      @SerializedName("access_token") private String accessToken;
      private String email;
      private String timezone;
      private String nickname;
      private String userImageURL;
    }
  }

  /**
   * /oauth/token/info
   */
  @Getter public static class Info {
    private String userId;
    private String email;
    private String timezone;
    private String nickname;
    private String userImageURL;
  }
}
