/*
 * Decompiled with CFR 0.152.
 */
package com.mediatek.mcs.pref;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import com.google.gson.Gson;
import com.mediatek.mcs.Mcs;
import com.mediatek.mcs.entity.McsMobileEntity;
import com.mediatek.mcs.pref.McsPreferences;
import org.json.JSONObject;

public final class McsMobile
implements McsPreferences {
    private static final String USER_INFO_MOBILE_ID = "USER_INFO_MOBILE_ID";
    private static McsMobile INSTANCE = new McsMobile();
    private Gson gson = new Gson();
    private SharedPreferences pref = PreferenceManager.getDefaultSharedPreferences((Context)Mcs.getApplicationContext());
    private String mobileId = this.pref.getString("USER_INFO_MOBILE_ID", "");

    private McsMobile() {
    }

    public static McsMobile getInstance() {
        return INSTANCE;
    }

    @Override
    public void clearPref() {
        this.mobileId = "";
        this.savePref();
    }

    @Override
    public void savePref() {
        SharedPreferences.Editor editor = this.pref.edit();
        editor.putString(USER_INFO_MOBILE_ID, this.mobileId);
        editor.commit();
    }

    public void saveToPref(JSONObject response) {
        this.saveUserMobile((McsMobileEntity)this.gson.fromJson(response.toString(), McsMobileEntity.class));
    }

    private void saveUserMobile(McsMobileEntity mobile) {
        this.setMobileId(mobile.getMobileId());
        this.savePref();
    }

    public String getMobileId() {
        return this.mobileId;
    }

    public void setMobileId(String mobileId) {
        this.mobileId = mobileId;
    }
}

