/*
 * Decompiled with CFR 0.152.
 */
package com.mediatek.mcs.domain;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.DisplayMetrics;
import com.google.gson.Gson;
import com.mediatek.mcs.Mcs;
import com.mediatek.mcs.domain.McsPushInstallation;
import com.mediatek.mcs.entity.RegisterMobileEntity;

public class McsRegisterMobile {
    String manufacturer;
    String model;
    String name;
    String appName;
    String applicationId;
    String versionName;
    int versionCode;
    int sdkInt;
    String regId;
    String APP_KEY;
    String mcsClientId;

    public McsRegisterMobile() {
        Context context = Mcs.getApplicationContext();
        this.manufacturer = Build.MANUFACTURER.toUpperCase();
        this.model = Build.MODEL;
        this.name = this.manufacturer + " " + this.model;
        this.sdkInt = Build.VERSION.SDK_INT;
        this.appName = context.getString(context.getApplicationInfo().labelRes);
        this.applicationId = Mcs.getApplicationContext().getPackageName();
        this.mcsClientId = Mcs.MCS_CLIENT_ID;
        try {
            this.versionName = context.getPackageManager().getPackageInfo((String)this.applicationId, (int)0).versionName;
            this.versionCode = context.getPackageManager().getPackageInfo((String)this.applicationId, (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.versionName = "0.0.2";
            this.versionCode = 1;
        }
        this.regId = McsPushInstallation.getInstance().getRegId();
        this.APP_KEY = McsPushInstallation.getInstance().getAppKey();
    }

    public String toString() {
        return new Gson().toJson((Object)new RegisterMobileEntity(this.name, this.regId, this.APP_KEY, new RegisterMobileEntity.Info(this.mcsClientId, this.manufacturer, this.model, this.applicationId, this.appName, this.versionName, this.versionCode, this.sdkInt, this.getScreenMetrics())), RegisterMobileEntity.class);
    }

    private RegisterMobileEntity.Info.ScreenMetrics getScreenMetrics() {
        DisplayMetrics displayMetrics = Mcs.getApplicationContext().getResources().getDisplayMetrics();
        float f2 = displayMetrics.density;
        int n = displayMetrics.widthPixels;
        int n2 = displayMetrics.heightPixels;
        float f3 = displayMetrics.xdpi;
        float f4 = displayMetrics.ydpi;
        float f5 = (float)n / f3;
        float f6 = (float)n2 / f4;
        double d2 = Math.sqrt(f5 * f5 + f6 * f6);
        return new RegisterMobileEntity.Info.ScreenMetrics(f2, n, n2, d2);
    }
}

