/*
 * Decompiled with CFR 0.152.
 */
package com.mediatek.mcs.domain;

import android.text.TextUtils;
import com.android.volley.AuthFailureError;
import com.android.volley.Request;
import com.mediatek.mcs.McsLog;
import com.mediatek.mcs.domain.McsRegisterMobile;
import com.mediatek.mcs.domain.McsResponse;
import com.mediatek.mcs.domain.c;
import com.mediatek.mcs.domain.d;
import com.mediatek.mcs.domain.e;
import com.mediatek.mcs.entity.ResponseMessage;
import com.mediatek.mcs.exception.SdkInstallationException;
import com.mediatek.mcs.net.McsJsonRequest;
import com.mediatek.mcs.net.RequestApi;
import com.mediatek.mcs.net.RequestManager;
import com.mediatek.mcs.net.RequestUtils;
import com.mediatek.mcs.pref.McsMobile;
import com.mediatek.mcs.push.PushRegistration;
import java.util.Map;
import org.json.JSONObject;

public final class McsPushInstallation {
    public static final int PUSH_GCM = 101;
    private static McsPushInstallation INSTANCE = new McsPushInstallation();
    private boolean isRegistered = false;
    private boolean isUpdateRegId = false;
    private String gcmSenderId;
    private String appKey = "";
    private String regId;

    private McsPushInstallation() {
    }

    public static McsPushInstallation getInstance() {
        return INSTANCE;
    }

    public void registerInBackground(String gcm_sender_id, String gcm_api_key) {
        this.isRegistered = true;
        this.gcmSenderId = gcm_sender_id;
        this.appKey = gcm_api_key;
        try {
            new PushRegistration(gcm_sender_id, gcm_api_key);
        }
        catch (SdkInstallationException sdkInstallationException) {
            McsLog.e(sdkInstallationException.getMessage(), new Object[0]);
        }
    }

    public void setup(String regId, String appKey) {
        this.regId = regId;
        this.appKey = appKey;
    }

    public void requestRegisterMobile(McsResponse.SuccessListener<JSONObject> successListener, McsResponse.ErrorListener errorListener) throws SdkInstallationException {
        String string2;
        int n;
        if (!PushRegistration.isPushInstalled(this.gcmSenderId, this.appKey) || TextUtils.isEmpty((CharSequence)this.regId)) {
            this.registerInBackground(this.gcmSenderId, this.appKey);
            return;
        }
        if (this.isUpdateRegId) {
            McsLog.d("Update mobile", new Object[0]);
            n = 2;
            string2 = RequestApi.UPDATE_MOBILE.replace("{mobileId}", McsMobile.getInstance().getMobileId());
        } else {
            McsLog.d("Register mobile", new Object[0]);
            n = 1;
            string2 = RequestApi.REGISTER_MOBILE;
        }
        String string3 = new McsRegisterMobile().toString();
        McsResponse.SuccessListener successListener2 = c.a(successListener);
        McsResponse.ErrorListener errorListener2 = errorListener;
        errorListener2.getClass();
        RequestManager.sendInBackground((Request)new McsJsonRequest(n, string2, string3, successListener2, d.a(errorListener2)));
    }

    public void requestUnRegisterMobile(final String accessToken) {
        if (TextUtils.isEmpty((CharSequence)McsMobile.getInstance().getMobileId())) {
            McsLog.e("mobileId is empty, still sign out.", new Object[0]);
            return;
        }
        RequestManager.sendInBackground((Request)new McsJsonRequest(3, RequestApi.UPDATE_MOBILE.replace("{mobileId}", McsMobile.getInstance().getMobileId()), e.a()){

            @Override
            public Map<String, String> getHeaders() throws AuthFailureError {
                return RequestUtils.getSignOutHeader(accessToken);
            }
        });
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    public boolean isUpdateRegId() {
        return this.isUpdateRegId;
    }

    public void setIsUpdateRegId(boolean isUpdateRegId) {
        this.isUpdateRegId = isUpdateRegId;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public String getRegId() {
        return this.regId;
    }

    private static /* synthetic */ void lambda$requestUnRegisterMobile$6(JSONObject response) {
        McsMobile.getInstance().clearPref();
        McsLog.d("mobile unregistered.", new Object[0]);
    }

    private static /* synthetic */ void lambda$requestRegisterMobile$5(McsResponse.SuccessListener successListener, JSONObject response) {
        McsMobile.getInstance().saveToPref(response);
        successListener.onSuccess(ResponseMessage.create("register mobile success"));
    }

    static /* synthetic */ void access$lambda$0(McsResponse.SuccessListener successListener, JSONObject jSONObject) {
        McsPushInstallation.lambda$requestRegisterMobile$5(successListener, jSONObject);
    }

    static /* synthetic */ void access$lambda$1(JSONObject jSONObject) {
        McsPushInstallation.lambda$requestUnRegisterMobile$6(jSONObject);
    }
}

