/*
 * Decompiled with CFR 0.152.
 */
package com.mediatek.mcs.domain;

import com.mediatek.mcs.R;
import com.mediatek.mcs.domain.McsDataChannelType;
import com.mediatek.mcs.domain.McsGeoPoint;
import com.mediatek.mcs.entity.DataChannelEntity;
import com.mediatek.mcs.entity.DataPointEntity;
import com.mediatek.mcs.exception.InvalidDataPointException;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class DataPointFormatter {
    public static DataPointEntity.Values formatValues(DataChannelEntity channel, DataPointEntity.Values values) throws InvalidDataPointException {
        if (values == null) {
            throw new InvalidDataPointException(R.string.error_invalid_upload_dp);
        }
        switch (McsDataChannelType.getChannelType(channel)) {
            case 1: 
            case 2: {
                return DataPointFormatter.getFormatValues(values.getValue());
            }
            case 4: 
            case 5: {
                return values;
            }
            case 6: {
                return new DataPointEntity.Values(new McsGeoPoint(values).trim());
            }
            case 12: 
            case 26: {
                return DataPointFormatter.getFormatValues(values.getValue(), values.getPeriod());
            }
            case 7: 
            case 10: 
            case 11: {
                return values;
            }
        }
        return null;
    }

    public static DataPointEntity.Values getFormatValues(String value) throws InvalidDataPointException {
        return new DataPointEntity.Values(DataPointFormatter.formatDecimal(value));
    }

    public static DataPointEntity.Values getFormatValues(String value, String period) throws InvalidDataPointException {
        return new DataPointEntity.Values(DataPointFormatter.formatDecimal(value), DataPointFormatter.formatDecimal(period));
    }

    private static String formatDecimal(String decimalString) throws InvalidDataPointException {
        try {
            String string2 = decimalString.replaceFirst("^0+(?!$)", "");
            DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance();
            decimalFormat.setMinimumIntegerDigits(1);
            decimalFormat.setMaximumFractionDigits(16);
            decimalFormat.setGroupingUsed(false);
            return decimalFormat.format(Double.parseDouble(string2));
        }
        catch (Exception exception) {
            throw new InvalidDataPointException(R.string.error_invalid_upload_dp, (Throwable)exception);
        }
    }

    public static String trimGeoValue(Object value) throws InvalidDataPointException {
        try {
            DecimalFormat decimalFormat = new DecimalFormat("#.######");
            decimalFormat.setRoundingMode(RoundingMode.HALF_EVEN);
            value = Float.valueOf(Float.parseFloat(value.toString()));
            return decimalFormat.format(value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidDataPointException(R.string.error_invalid_upload_dp, (Throwable)numberFormatException);
        }
    }
}

