package com.mediatek.mcs.pref;

import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.preference.PreferenceManager;
import com.google.gson.Gson;
import com.mediatek.mcs.Mcs;
import com.mediatek.mcs.entity.AuthEntity;
import org.json.JSONObject;

/**
 * Notice: token is different from access_token.
 */
public final class McsUser implements McsPreferences {

  private static final String USER_EMAIL = "USER_EMAIL";
  private static final String USER_PASSWORD = "USER_PASSWORD";
  private static final String USER_TOKEN = "USER_TOKEN";
  private static final String USER_ACCESS_TOKEN = "USER_ACCESS_TOKEN";
  private static final String USER_REMEMBER_ME = "USER_REMEMBER_ME";
  private static McsUser INSTANCE = new McsUser();
  private Gson gson = new Gson();
  private SharedPreferences pref;
  private String email;
  private String password;
  private String token;
  private String accessToken;
  private boolean isRememberMe;
  private McsUser() {
    pref = PreferenceManager.getDefaultSharedPreferences(Mcs.getApplicationContext());

    this.email = pref.getString(USER_EMAIL, "");
    this.password = pref.getString(USER_PASSWORD, "");
    this.token = pref.getString(USER_TOKEN, "");
    this.accessToken = pref.getString(USER_ACCESS_TOKEN, "");
    this.isRememberMe = pref.getBoolean(USER_REMEMBER_ME, false);
  }

  public static McsUser getInstance() {
    return INSTANCE;
  }

  public void clearPref() {
    this.email = "";
    this.password = "";
    this.isRememberMe = false;
    this.token = "";
    this.accessToken = "";
    savePref();
  }

  public void savePref() {
    Editor editor = pref.edit();
    editor.putString(USER_EMAIL, this.email);
    editor.putString(USER_PASSWORD, this.password);
    editor.putString(USER_TOKEN, this.token);
    editor.putString(USER_ACCESS_TOKEN, this.accessToken);
    editor.putBoolean(USER_REMEMBER_ME, this.isRememberMe);
    editor.commit();
  }

  public void saveToPref(JSONObject response) {
    saveUser(gson.fromJson(response.toString(), AuthEntity.Token.class));
  }

  private void saveUser(AuthEntity.Token auth) {
    this.setToken(auth.getToken());
    this.setAccessToken(auth.getAccessToken());
    this.savePref();
  }

  public String getEmail() {
    return this.email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  public String getPassword() {
    return this.password;
  }

  public void setPassword(String password) {
    this.password = password;
  }

  public boolean isRememberMe() {
    return this.isRememberMe;
  }

  public void setRememberMe(boolean rememberMe) {
    this.isRememberMe = rememberMe;
  }

  public String getToken() {
    return token;
  }

  public void setToken(String token) {
    this.token = token;
  }

  public String getAccessToken() {
    return accessToken;
  }

  public void setAccessToken(String accessToken) {
    this.accessToken = accessToken;
  }
}
