package com.mediatek.mcs.entity;

import java.util.List;

public class DeviceNotifEntity extends McsEntity {
  private NotifGroup[] deviceNtfCritGrps;

  public NotifGroup[] getDeviceNtfCritGrps() {
    return deviceNtfCritGrps;
  }

  public static class NotifGroup {
    private String name;
    private List<Criterion> ntfcrits;
    private List<Method> ntfmths;
    /**
     * required field for UPDATE_DEVICE_NOTIF_GROUP
     */
    private String ntfCritGrpId;
    private Boolean isProdActivated;
    private Boolean isDeviceActivated;

    public String getName() {
      return name;
    }

    public List<Criterion> getNtfcrits() {
      return ntfcrits;
    }

    public List<Method> getNtfmths() {
      return ntfmths;
    }

    public Boolean getIsProdActivated() {
      return isProdActivated;
    }

    public Boolean getIsDeviceActivated() {
      return isDeviceActivated;
    }

    public String getNtfCritGrpId() {
      return ntfCritGrpId;
    }
  }

  public static class Criterion {
    private Float thresholdValue;     // if null, use defaultThresholdValue
    private Float defaultThresholdValue;
    private String operand;
    private String name;
    private Format format;
    private UnitTypeEntity unitType;

    /**
     * required field for UPDATE_DEVICE_NOTIF_GROUP
     */
    private Integer ntfCritId;
    private Integer streamId;

    public Float getThresholdValue() {
      return thresholdValue;
    }

    public Float getDefaultThresholdValue() {
      return defaultThresholdValue;
    }

    public String getOperand() {
      return operand;
    }

    public String getName() {
      return name;
    }

    public Format getFormat() {
      return format;
    }

    public Integer getNtfCritId() {
      return ntfCritId;
    }

    public Integer getStreamId() {
      return streamId;
    }

    public UnitTypeEntity getUnitType() {
      return unitType;
    }
  }

  public static class Method {
    private String name;
    private String title;
    private String content;

    public String getName() {
      return name;
    }

    public String getTitle() {
      return title;
    }

    public String getContent() {
      return content;
    }
  }

  public static class Format {
    private String lowerbound;
    private String upperbound;

    public String getLowerbound() {
      return lowerbound;
    }

    public String getUpperbound() {
      return upperbound;
    }
  }

  public static class Update {
    private Boolean isActivated;
    private List<UpdateCriterion> ntfcrits;

    public Update(Boolean isActivated, List<UpdateCriterion> criteria) {
      this.isActivated = isActivated;
      this.ntfcrits = criteria;
    }
  }

  public static class UpdateCriterion {
    /**
     * required field for UPDATE_DEVICE_NOTIF_GROUP
     */
    private Integer ntfCritId;
    private Integer streamId;
    private Float thresholdValue;

    public UpdateCriterion(Integer ntfCritId, Integer streamId, Float thresholdValue) {
      this.ntfCritId = ntfCritId;
      this.streamId = streamId;
      this.thresholdValue = thresholdValue;
    }
  }
}
