package com.mediatek.mcs.Utils;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.Gravity;
import android.widget.Toast;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mediatek.mcs.Mcs;
import com.mediatek.mcs.R;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class UIUtils {
  public static final String FONT_ASSET = "fonts/Mika Melvas - RionaSans-Regular.otf";
  public static final String SERVER_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
  public static final String DISPLAY_DATE_FORMAT = "yyyy-MM-dd HH:mm";

  public static Gson getFormattedGson() {
    return new GsonBuilder().setDateFormat(
        new SimpleDateFormat(SERVER_DATE_FORMAT, Locale.getDefault()).toPattern()).create();
  }

  public static String getDateString(Date updatedAt) {
    try {
      return new SimpleDateFormat(DISPLAY_DATE_FORMAT, Locale.getDefault()).format(updatedAt);
    } catch (Exception e) {
      return "";
    }
  }

  public static String getDateString(Long timeMillis) {
    return getDateString(new Date(timeMillis));
  }

  public static void setTitleAlertDialog(Context context, String title,
      DialogInterface.OnClickListener positiveListener) {
    new AlertDialog.Builder(context).setIconAttribute(android.R.attr.alertDialogIcon)
        .setTitle(String.format(title, context.getString(R.string.app_name)))
        .setPositiveButton(R.string.dialog_action_affirmative, positiveListener)
        .setNegativeButton(android.R.string.cancel,
            (dialog, dismissiveAction) -> {
              /* User clicked Cancel so do some stuff */
            })
        .create()
        .show();
  }

  public static void toast(int resId) {
    toast(Mcs.getApplicationContext().getString(resId));
  }

  public static void toast(String msg) {
    toast(msg, true, false);
  }

  public static void toast(int resId, Boolean isShort, Boolean isCenter) {
    toast(Mcs.getApplicationContext().getString(resId), isShort, isCenter);
  }

  public static void toast(String msg, Boolean isShort, Boolean isCenter) {
    Toast toast = Toast.makeText(Mcs.getApplicationContext(), msg,
        isShort ? Toast.LENGTH_SHORT : Toast.LENGTH_LONG);
    if (isCenter) toast.setGravity(Gravity.CENTER, 0, 0);
    toast.show();
  }
}
