/*
 * Decompiled with CFR 0.152.
 */
package com.mediatek.mcs.push;

import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import com.mediatek.mcs.Mcs;
import com.mediatek.mcs.McsLog;
import com.mediatek.mcs.R;
import com.mediatek.mcs.domain.McsPushInstallation;
import com.mediatek.mcs.exception.SdkInstallationException;
import com.mediatek.mcs.push.GcmPreference;
import java.io.IOException;

public class PushRegistration {
    private String GCM_SENDER_ID = "";
    private String GCM_API_KEY = "";
    Context context = Mcs.getApplicationContext();
    GoogleCloudMessaging gcm;
    String mRegId;

    public PushRegistration(String gcm_sender_id, String gcm_api_key) throws SdkInstallationException {
        this.GCM_SENDER_ID = gcm_sender_id;
        this.GCM_API_KEY = gcm_api_key;
        if (!PushRegistration.isPushInstalled(this.GCM_SENDER_ID, this.GCM_API_KEY)) {
            return;
        }
        this.gcm = GoogleCloudMessaging.getInstance((Context)this.context);
        this.mRegId = GcmPreference.getInstance().getRegistrationId(this.context);
        if (TextUtils.isEmpty((CharSequence)this.mRegId)) {
            this.registerInBackground();
        } else {
            this.setupGcmInstallation();
        }
    }

    public static boolean isPushInstalled(String gcm_sender_id, String gcm_api_key) throws SdkInstallationException {
        int n = GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(Mcs.getApplicationContext());
        if (n != 0) {
            McsLog.e(Mcs.getApplicationContext().getString(R.string.error_install_no_google_play) + "\nplayServiceResult errorCode: " + n, new Object[0]);
        }
        if (TextUtils.isEmpty((CharSequence)gcm_sender_id) || TextUtils.isEmpty((CharSequence)gcm_api_key)) {
            throw new SdkInstallationException(R.string.error_install_push_gcm_invalid);
        }
        return true;
    }

    private void registerInBackground() {
        new AsyncTask<Void, Void, String>(){

            protected String a(Void ... voidArray) {
                String string2 = "";
                try {
                    if (PushRegistration.this.gcm == null) {
                        PushRegistration.this.gcm = GoogleCloudMessaging.getInstance((Context)PushRegistration.this.context);
                    }
                    PushRegistration.this.mRegId = PushRegistration.this.gcm.register(new String[]{PushRegistration.this.GCM_SENDER_ID});
                    string2 = "Device registered, registration ID = " + PushRegistration.this.mRegId;
                    GcmPreference.getInstance().storeRegistrationId(PushRegistration.this.context, PushRegistration.this.mRegId);
                    PushRegistration.this.setupGcmInstallation();
                }
                catch (IOException iOException) {
                    string2 = "Failed to Register GCM. Error :" + iOException.getMessage();
                    McsLog.e(string2, new Object[0]);
                }
                McsLog.d("GCM register msg: " + string2, new Object[0]);
                return string2;
            }

            protected /* synthetic */ Object doInBackground(Object[] objectArray) {
                return this.a((Void[])objectArray);
            }
        }.execute((Object[])new Void[]{null, null, null});
    }

    void setupGcmInstallation() {
        McsPushInstallation.getInstance().setup(this.mRegId, this.GCM_API_KEY);
        McsPushInstallation.getInstance().setIsUpdateRegId(GcmPreference.getInstance().isUpdateRegId());
        McsLog.d("Gcm installed successfully", new Object[0]);
    }
}

