package com.mediatek.mcs.socket;

import com.mediatek.mcs.domain.McsDataChannel;

public class SocketManager {
  public static String getSocketUrl(McsDataChannel channel) {
    final String DATA_CHANNEL_SOCKET = "/devices/{deviceId}/dataChannels/{datachannelId}";

    return DATA_CHANNEL_SOCKET
        .replace("{deviceId}", channel.getDeviceId())
        .replace("{datachannelId}", channel.getChannelId());
  }

  public static String getSocketUrl(String mobileId) {
    final String MOBILE_PROFILE_SOCKET = "/mobiles/{mobileId}/switch";

    return MOBILE_PROFILE_SOCKET
        .replace("{mobileId}", mobileId);
  }

  public static void registerSocket(McsDataChannel dataChannel, McsSocketListener socketListener) {
    McsSocket.getInstance().on(getSocketUrl(dataChannel), socketListener);
  }

  public static void unregisterSocket(McsDataChannel channel, McsSocketListener socketListener) {
    McsSocket.getInstance().off(getSocketUrl(channel), socketListener);
  }

  public static void registerSocket(String mobileId, McsSocketListener socketListener) {
    McsSocket.getInstance().on(getSocketUrl(mobileId), socketListener);
  }

  public static void unregisterSocket(String mobileId, McsSocketListener socketListener) {
    McsSocket.getInstance().off(getSocketUrl(mobileId), socketListener);
  }

  public static void connectSocket() {
    McsSocket.getInstance().connect();
  }

  public static void disconnectSocket() {
    McsSocket.getInstance().disconnect();
  }
}
