package com.mediatek.mcs.socket;

import android.os.Handler;
import com.mediatek.mcs.Mcs;
import com.mediatek.mcs.McsLog;
import io.socket.emitter.Emitter;
import org.json.JSONObject;

public class McsSocketListener implements Emitter.Listener {
  private OnUpdateListener onUpdateListener;

  public McsSocketListener(OnUpdateListener listener) {
    this.onUpdateListener = listener;
  }

  @Override public void call(Object... args) {
    if (args.length != 0) {
      new Handler(Mcs.getApplicationContext().getMainLooper()).post(
          () -> this.onUpdateListener.onUpdate((JSONObject) args[0]));
    } else {
      McsLog.e("args.length == 0");
    }
  }

  public interface OnUpdateListener {
    void onUpdate(JSONObject data);
  }
}
